/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.javers.common.string.ToStringBuilder;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.type.ManagedType;

public class DuckType {
    private final String typeName;
    private final Set<String> properties;

    public DuckType(ManagedType managedType) {
        this(managedType.getName(), managedType.getPropertyNames());
    }

    public DuckType(String typeName) {
        this(typeName, Collections.emptySet());
    }

    public DuckType(String typeName, Set<String> properties) {
        Validate.argumentsAreNotNull(typeName, properties);
        this.typeName = typeName;
        this.properties = new HashSet<String>(properties);
    }

    public DuckType bareCopy() {
        return new DuckType(this.typeName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DuckType duckType = (DuckType)o;
        return Objects.equals(this.typeName, duckType.typeName) && Objects.equals(this.properties, duckType.properties);
    }

    public int hashCode() {
        return Objects.hash(this.typeName, this.properties);
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String toString() {
        return "DuckType{typeName='" + this.typeName + "', properties=" + ToStringBuilder.setToString(this.properties) + "}";
    }

    public boolean isBare() {
        return this.properties.isEmpty();
    }
}

