/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.appenders.levenshtein;

import java.util.List;
import org.javers.core.diff.EqualsFunction;
import org.javers.core.diff.appenders.levenshtein.BacktrackSteps;

class Backtrack {
    private static final int PENALTY = 1;
    private final EqualsFunction equalsFunction;

    public Backtrack(EqualsFunction equalsFunction) {
        this.equalsFunction = equalsFunction;
    }

    BacktrackSteps[][] evaluateSteps(List leftList, List rightList) {
        int leftDim = leftList.size() + 1;
        int rightDim = rightList.size() + 1;
        BacktrackSteps[][] steps = new BacktrackSteps[leftDim][rightDim];
        int[][] scores = this.initScores(leftDim, rightDim);
        for (int i = 1; i < leftDim; ++i) {
            for (int j = 1; j < rightDim; ++j) {
                int skipLeft = scores[i - 1][j] - 1;
                int skipRight = scores[i][j - 1] - 1;
                int take = scores[i - 1][j - 1] - this.compareListElements(leftList.get(i - 1), rightList.get(j - 1));
                int max = Math.max(skipLeft, Math.max(skipRight, take));
                BacktrackSteps step = max == skipLeft ? BacktrackSteps.SKIP_LEFT : (max == skipRight ? BacktrackSteps.SKIP_RIGHT : BacktrackSteps.TAKE);
                scores[i][j] = max;
                steps[i][j] = step;
            }
        }
        return steps;
    }

    private int[][] initScores(int leftDim, int rightDim) {
        int[][] s = new int[leftDim][rightDim];
        for (int i = 0; i < leftDim; ++i) {
            s[i][0] = -i * 1;
        }
        for (int j = 0; j < rightDim; ++j) {
            s[0][j] = -j * 1;
        }
        return s;
    }

    private int compareListElements(Object left, Object right) {
        if (this.equalsFunction.nullSafeEquals(left, right)) {
            return 0;
        }
        return 1;
    }
}

