/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.jql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.javers.common.collections.Consumer;
import org.javers.common.collections.Lists;
import org.javers.common.string.ToStringBuilder;
import org.javers.common.validation.Validate;
import org.javers.core.CommitIdGenerator;
import org.javers.core.CoreConfiguration;
import org.javers.core.commit.CommitId;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.InstanceId;
import org.javers.core.metamodel.object.ValueObjectId;
import org.javers.repository.api.JaversExtendedRepository;
import org.javers.repository.api.QueryParams;
import org.javers.repository.api.QueryParamsBuilder;
import org.javers.repository.jql.JqlQuery;
import org.javers.repository.jql.SnapshotQueryRunner;
import org.javers.shadow.Shadow;
import org.javers.shadow.ShadowFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ShadowQueryRunner {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.javers.JQL");
    private final SnapshotQueryRunner snapshotQueryRunner;
    private final JaversExtendedRepository repository;
    private final ShadowFactory shadowFactory;
    private final CoreConfiguration javersCoreConfiguration;

    ShadowQueryRunner(SnapshotQueryRunner snapshotQueryRunner, JaversExtendedRepository repository, ShadowFactory shadowFactory, CoreConfiguration javersCoreConfiguration) {
        this.snapshotQueryRunner = snapshotQueryRunner;
        this.repository = repository;
        this.shadowFactory = shadowFactory;
        this.javersCoreConfiguration = javersCoreConfiguration;
    }

    ShadowQueryResult queryForShadows(JqlQuery query, List<CdoSnapshot> gapsFilledInPreviousQuery) {
        ShadowStats queryStats = new ShadowStats();
        List<CdoSnapshot> coreSnapshots = this.queryForCoreSnapshots(query, queryStats);
        CommitTable commitTable = new CommitTable(coreSnapshots, query.getMaxGapsToFill(), query, queryStats);
        commitTable.appendSnapshots(gapsFilledInPreviousQuery);
        if (query.getShadowScope().isCommitDeep()) {
            commitTable.loadFullCommits();
        }
        List<Shadow> shadows = commitTable.rootsForQuery(query).stream().map(r -> this.shadowFactory.createShadow(r.root, r.context, (cm, targetId) -> commitTable.referenceResolver((CommitMetadata)cm, (GlobalId)targetId))).collect(Collectors.toList());
        queryStats.stop();
        ShadowQueryResult result = new ShadowQueryResult(shadows, commitTable.getFilledGapsSnapshots(), queryStats);
        return result;
    }

    private List<CdoSnapshot> queryForCoreSnapshots(JqlQuery query, ShadowStats queryStats) {
        List<CdoSnapshot> snapshots = this.snapshotQueryRunner.queryForSnapshots(query).stream().filter(s -> !s.isTerminalVO()).collect(Collectors.toList());
        queryStats.logShallowQuery(snapshots);
        return snapshots;
    }

    static class ShadowStats {
        private long startTimestamp = System.currentTimeMillis();
        private long endTimestamp;
        private int dbQueriesCount;
        private int allSnapshotsCount;
        private int shallowSnapshotsCount;
        private int deepPlusSnapshotsCount;
        private int commitDeepSnapshotsCount;
        private int childVOSnapshotsCount;
        private int deepPlusGapsFilled;
        private int deepPlusGapsLeft;

        ShadowStats() {
        }

        void logQueryInChildValueObjectScope(GlobalId reference, CommitId context, int snapshotsLoaded) {
            this.validateChange();
            logger.debug("CHILD_VALUE_OBJECT query for '{}' at timepointCommitId {}, {} snapshot(s) loaded", new Object[]{reference.toString(), context.value(), snapshotsLoaded});
            ++this.dbQueriesCount;
            this.allSnapshotsCount += snapshotsLoaded;
            this.childVOSnapshotsCount += snapshotsLoaded;
        }

        void logMaxGapsToFillExceededInfo(GlobalId reference) {
            this.validateChange();
            ++this.deepPlusGapsLeft;
            logger.debug("warning: object '" + reference.toString() + "' is outside of the DEEP_PLUS+{} scope, references to this object will be nulled. Increase maxGapsToFill and fill all gaps in your object graph.", (Object)this.deepPlusGapsFilled);
        }

        void logQueryInDeepPlusScope(GlobalId reference, CommitId context, int snapshotsLoaded) {
            this.validateChange();
            ++this.dbQueriesCount;
            this.allSnapshotsCount += snapshotsLoaded;
            this.deepPlusSnapshotsCount += snapshotsLoaded;
            ++this.deepPlusGapsFilled;
            logger.debug("DEEP_PLUS query for '{}' at timepointCommitId {}, {} snapshot(s) loaded, gaps filled so far: {}", new Object[]{reference.toString(), context.value(), snapshotsLoaded, this.deepPlusGapsFilled});
        }

        void logShallowQuery(List<CdoSnapshot> snapshots) {
            this.validateChange();
            logger.debug("SHALLOW query (core snapshots): {} snapshots loaded (entities: {}, valueObjects: {})", new Object[]{snapshots.size(), snapshots.stream().filter(it -> it.getGlobalId() instanceof InstanceId).count(), snapshots.stream().filter(it -> it.getGlobalId() instanceof ValueObjectId).count()});
            ++this.dbQueriesCount;
            this.allSnapshotsCount += snapshots.size();
            this.shallowSnapshotsCount += snapshots.size();
        }

        void logQueryInCommitDeepScope(List<CdoSnapshot> snapshots) {
            this.validateChange();
            logger.debug("COMMIT_DEEP query: {} snapshots loaded", (Object)snapshots.size());
            ++this.dbQueriesCount;
            this.allSnapshotsCount += snapshots.size();
            this.commitDeepSnapshotsCount += snapshots.size();
        }

        void stop() {
            this.validateChange();
            this.endTimestamp = System.currentTimeMillis();
        }

        public String toString() {
            if (this.getEndTimestamp() == 0L) {
                return ToStringBuilder.toString(this, "still running", "?");
            }
            return ToStringBuilder.toStringBlockStyle(this, "  ", this.toStringProps().toArray());
        }

        List<Object> toStringProps() {
            return Lists.asList("executed in millis", this.getEndTimestamp() - this.getStartTimestamp(), "DB queries", this.getDbQueriesCount(), "snapshots loaded", this.getAllSnapshotsCount(), "SHALLOW snapshots", this.getShallowSnapshotsCount(), "COMMIT_DEEP snapshots", this.getCommitDeepSnapshotsCount(), "CHILD_VALUE_OBJECT snapshots", this.getChildVOSnapshotsCount(), "DEEP_PLUS snapshots", this.getDeepPlusSnapshotsCount(), "gaps filled", this.getDeepPlusGapsFilled(), "gaps left!", this.getDeepPlusGapsLeft());
        }

        public int getDbQueriesCount() {
            return this.dbQueriesCount;
        }

        public int getAllSnapshotsCount() {
            return this.allSnapshotsCount;
        }

        public long getStartTimestamp() {
            return this.startTimestamp;
        }

        public long getEndTimestamp() {
            return this.endTimestamp;
        }

        public int getShallowSnapshotsCount() {
            return this.shallowSnapshotsCount;
        }

        public int getDeepPlusSnapshotsCount() {
            return this.deepPlusSnapshotsCount;
        }

        public int getCommitDeepSnapshotsCount() {
            return this.commitDeepSnapshotsCount;
        }

        public int getChildVOSnapshotsCount() {
            return this.childVOSnapshotsCount;
        }

        public int getDeepPlusGapsFilled() {
            return this.deepPlusGapsFilled;
        }

        public int getDeepPlusGapsLeft() {
            return this.deepPlusGapsLeft;
        }

        private void validateChange() {
            if (this.endTimestamp > 0L) {
                throw new RuntimeException(new IllegalAccessException("executed query can't be changed"));
            }
        }
    }

    private class CommitTable {
        private final int maxGapsToFill;
        private final Map<CommitMetadata, CommitEntry> commitsMap;
        private final JqlQuery query;
        private int filledGapsCount;
        private final List<CdoSnapshot> filledGapsSnapshots = new ArrayList<CdoSnapshot>();
        private final ShadowStats queryStats;

        CommitTable(List<CdoSnapshot> coreSnapshots, int maxGapsToFill, JqlQuery query, ShadowStats queryStats) {
            this.maxGapsToFill = maxGapsToFill;
            this.query = query;
            this.commitsMap = new TreeMap<CommitMetadata, CommitEntry>(ShadowQueryRunner.this.javersCoreConfiguration.getCommitIdGenerator().getComparator());
            this.appendSnapshots(coreSnapshots);
            this.queryStats = queryStats;
        }

        List<ShadowRoot> rootsForQuery(JqlQuery query) {
            this.fillMissingParents();
            ArrayList orderedCommits = new ArrayList();
            this.commitsMap.values().forEach(it -> orderedCommits.add(0, it));
            return orderedCommits.stream().flatMap(e -> e.getAllStream().filter(s -> query.matches(s.getGlobalId())).map(s -> new ShadowRoot(e.commitMetadata, (CdoSnapshot)s))).collect(Collectors.toList());
        }

        void loadFullCommits() {
            if (this.commitsMap.isEmpty()) {
                return;
            }
            QueryParams params = QueryParamsBuilder.withLimit(Integer.MAX_VALUE).commitIds(this.commitsMap.keySet().stream().map(it -> it.getId()).collect(Collectors.toSet())).build();
            List<CdoSnapshot> fullCommitsSnapshots = ShadowQueryRunner.this.repository.getSnapshots(params);
            this.queryStats.logQueryInCommitDeepScope(fullCommitsSnapshots);
            this.appendSnapshots(fullCommitsSnapshots);
        }

        CdoSnapshot referenceResolver(CommitMetadata rootContext, GlobalId targetId) {
            SnapshotReference reference = new SnapshotReference(rootContext, targetId);
            if (!this.commitsMap.containsKey(rootContext)) {
                return null;
            }
            CdoSnapshot latest = this.findLatestToInCommitTable(reference);
            if (latest == null) {
                this.appendSnapshots(this.fillGapFromRepository(reference, 15));
            }
            if ((latest = this.findLatestToInCommitTable(reference)) == null) {
                this.queryStats.logMaxGapsToFillExceededInfo(targetId);
            }
            return latest;
        }

        List<CdoSnapshot> getFilledGapsSnapshots() {
            return this.filledGapsSnapshots;
        }

        private CdoSnapshot findLatestToInCommitTable(SnapshotReference reference) {
            ArrayList found = new ArrayList();
            this.iterateUntil(ce -> {
                if (ce.getAny(reference.targetId()) != null) {
                    found.add(ce.getAny(reference.targetId()));
                }
            }, reference.timepointCommitId());
            if (found.size() == 0) {
                return null;
            }
            return (CdoSnapshot)found.get(found.size() - 1);
        }

        private boolean isInChildValueObjectScope(SnapshotReference snapshotReference) {
            return this.query.isAggregate() && snapshotReference.targetId() instanceof ValueObjectId;
        }

        List<CdoSnapshot> fillGapFromRepository(SnapshotReference snapshotReference, int limit) {
            List<CdoSnapshot> historicals;
            if (this.filledGapsCount >= this.maxGapsToFill && !this.isInChildValueObjectScope(snapshotReference)) {
                return Collections.emptyList();
            }
            if (this.isInChildValueObjectScope(snapshotReference)) {
                historicals = this.getHistoricals(snapshotReference.targetId(), snapshotReference, false, limit);
                this.queryStats.logQueryInChildValueObjectScope(snapshotReference.targetId(), snapshotReference.timepointCommitId(), historicals.size());
            } else {
                historicals = this.getHistoricals(snapshotReference.targetId(), snapshotReference, this.query.isAggregate(), limit);
                this.queryStats.logQueryInDeepPlusScope(snapshotReference.targetId(), snapshotReference.timepointCommitId(), historicals.size());
            }
            ++this.filledGapsCount;
            this.filledGapsSnapshots.addAll(historicals);
            return historicals;
        }

        private List<CdoSnapshot> getHistoricals(GlobalId globalId, SnapshotReference timePoint, boolean withChildValueObjects, int limit) {
            if (ShadowQueryRunner.this.javersCoreConfiguration.getCommitIdGenerator() == CommitIdGenerator.SYNCHRONIZED_SEQUENCE) {
                return ShadowQueryRunner.this.repository.getHistoricals(globalId, timePoint.timepointCommitId(), withChildValueObjects, limit);
            }
            return ShadowQueryRunner.this.repository.getHistoricals(globalId, timePoint.timepoint().getCommitDate(), withChildValueObjects, limit);
        }

        void fillMissingParents() {
            HashMap movingLatest = new HashMap();
            this.commitsMap.values().forEach(commitEntry -> {
                commitEntry.getMissingParents().stream().filter(movingLatest::containsKey).forEach(voId -> commitEntry.append((CdoSnapshot)movingLatest.get(voId)));
                commitEntry.getAllStream().forEach(e -> movingLatest.put(e.getGlobalId(), e));
            });
        }

        void appendSnapshots(Collection<CdoSnapshot> snapshots) {
            snapshots.forEach(it -> this.appendSnapshot((CdoSnapshot)it));
        }

        CommitEntry appendSnapshot(CdoSnapshot snapshot) {
            CommitEntry entry = this.commitsMap.get(snapshot.getCommitMetadata());
            if (entry == null) {
                entry = new CommitEntry(snapshot.getCommitMetadata());
                this.commitsMap.put(snapshot.getCommitMetadata(), entry);
            }
            entry.append(snapshot);
            return entry;
        }

        void iterateUntil(Consumer<CommitEntry> consumer, CommitId bound) {
            for (CommitEntry ce : this.commitsMap.values()) {
                consumer.consume(ce);
                if (!ce.commitMetadata.getId().equals(bound)) continue;
                break;
            }
        }
    }

    static class ShadowQueryResult {
        private final List<Shadow> shadows;
        private final List<CdoSnapshot> filledGapsSnapshots;
        private final ShadowStats queryStats;

        ShadowQueryResult(List<Shadow> shadows, List<CdoSnapshot> filledGapsSnapshots, ShadowStats queryStats) {
            this.shadows = shadows;
            this.filledGapsSnapshots = filledGapsSnapshots;
            this.queryStats = queryStats;
        }

        List<Shadow> getShadows() {
            return this.shadows;
        }

        List<CdoSnapshot> getFilledGapsSnapshots() {
            return this.filledGapsSnapshots;
        }

        ShadowStats getQueryStats() {
            return this.queryStats;
        }
    }

    private static class ShadowRoot {
        final CommitMetadata context;
        final CdoSnapshot root;

        ShadowRoot(CdoSnapshot root) {
            this.context = root.getCommitMetadata();
            this.root = root;
        }

        ShadowRoot(CommitMetadata context, CdoSnapshot root) {
            this.context = context;
            this.root = root;
        }
    }

    static class SnapshotReference {
        private final CommitMetadata timepoint;
        private final GlobalId targetId;

        SnapshotReference(CommitMetadata rootContext, GlobalId targetId) {
            Validate.argumentsAreNotNull(rootContext, targetId);
            this.timepoint = rootContext;
            this.targetId = targetId;
        }

        CommitMetadata timepoint() {
            return this.timepoint;
        }

        GlobalId targetId() {
            return this.targetId;
        }

        CommitId timepointCommitId() {
            return this.timepoint.getId();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SnapshotReference that = (SnapshotReference)o;
            return Objects.equals(this.timepointCommitId(), this.timepointCommitId()) && Objects.equals(this.targetId, that.targetId);
        }

        public int hashCode() {
            return Objects.hash(this.timepointCommitId(), this.targetId);
        }
    }

    private static class CommitEntry {
        private final CommitMetadata commitMetadata;
        private final Map<GlobalId, CdoSnapshot> entities = new HashMap<GlobalId, CdoSnapshot>();
        private final Map<ValueObjectId, CdoSnapshot> valueObjects = new HashMap<ValueObjectId, CdoSnapshot>();

        CommitEntry(CommitMetadata commitMetadata) {
            this.commitMetadata = commitMetadata;
        }

        void append(CdoSnapshot snapshot) {
            if (snapshot.getGlobalId() instanceof InstanceId) {
                this.entities.put(snapshot.getGlobalId(), snapshot);
            }
            if (snapshot.getGlobalId() instanceof ValueObjectId) {
                this.valueObjects.put((ValueObjectId)snapshot.getGlobalId(), snapshot);
            }
        }

        CdoSnapshot getAny(GlobalId globalId) {
            if (this.entities.containsKey(globalId)) {
                return this.entities.get(globalId);
            }
            return this.valueObjects.get(globalId);
        }

        Collection<CdoSnapshot> getEntities() {
            return this.entities.values();
        }

        Stream<CdoSnapshot> getAllStream() {
            return Stream.concat(this.valueObjects.values().stream(), this.entities.values().stream());
        }

        Set<GlobalId> getMissingParents() {
            Set<GlobalId> result = this.valueObjects.keySet().stream().map(voId -> voId.getOwnerId()).filter(instanceId -> !this.entities.containsKey(instanceId)).collect(Collectors.toSet());
            result.addAll(this.valueObjects.keySet().stream().flatMap(voId -> voId.getParentValueObjectIds().stream()).filter(voId -> !this.valueObjects.containsKey(voId)).collect(Collectors.toSet()));
            return result;
        }
    }
}

