/*
 * Decompiled with CFR 0.152.
 */
package org.javers.common.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.javers.common.collections.Sets;
import org.javers.common.reflection.ReflectionUtil;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.property.MissingProperty;

public abstract class JaversMember<T extends Member> {
    private final T rawMember;
    private final Optional<Type> resolvedReturnType;
    private final boolean looksLikeId;
    private final Map<Class, Optional<JaversMember>> mirrorMembersMemoized = new ConcurrentHashMap<Class, Optional<JaversMember>>();

    protected JaversMember(T rawMember, Type resolvedReturnType) {
        this(rawMember, resolvedReturnType, ReflectionUtil.looksLikeId(rawMember));
    }

    protected JaversMember(T rawMember, Type resolvedReturnType, boolean looksLikeId) {
        Validate.argumentIsNotNull(rawMember);
        this.rawMember = rawMember;
        this.resolvedReturnType = Optional.ofNullable(resolvedReturnType);
        this.looksLikeId = looksLikeId;
        this.setAccessibleIfNecessary((Member)rawMember);
    }

    protected abstract Type getRawGenericType();

    public abstract Class<?> getRawType();

    public T getRawMember() {
        return this.rawMember;
    }

    public Type getGenericResolvedType() {
        if (this.resolvedReturnType.isPresent()) {
            return this.resolvedReturnType.get();
        }
        return this.getRawGenericType();
    }

    public Class<?> getDeclaringClass() {
        return this.rawMember.getDeclaringClass();
    }

    public String name() {
        return this.rawMember.getName();
    }

    public String propertyName() {
        return this.rawMember.getName();
    }

    public Set<Annotation> getAnnotations() {
        return ReflectionUtil.getAnnotations(this.rawMember);
    }

    public Set<Class<? extends Annotation>> getAnnotationTypes() {
        return Sets.transform(this.getAnnotations(), ann -> ann.annotationType());
    }

    public boolean looksLikeId() {
        return this.looksLikeId;
    }

    public abstract Object getEvenIfPrivate(Object var1);

    public abstract void setEvenIfPrivate(Object var1, Object var2);

    void setAccessibleIfNecessary(Member rawMember) {
        if (!this.isPublic(rawMember)) {
            ((AccessibleObject)((Object)rawMember)).setAccessible(true);
        }
    }

    private boolean isPublic(Member member) {
        return Modifier.isPublic(member.getModifiers()) && Modifier.isPublic(member.getDeclaringClass().getModifiers());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JaversMember that = (JaversMember)o;
        return this.rawMember.equals(that.rawMember) && this.resolvedReturnType.equals(that.resolvedReturnType);
    }

    public int hashCode() {
        return this.rawMember.hashCode() + this.resolvedReturnType.hashCode();
    }

    Object getOnMissingProperty(Object onObject) {
        Optional mirror = this.mirrorMembersMemoized.computeIfAbsent(onObject.getClass(), c -> ReflectionUtil.getMirrorMember(this, c));
        return mirror.map(s -> s.getEvenIfPrivate(onObject)).orElse(MissingProperty.INSTANCE);
    }

    public abstract String memberType();
}

