/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.lang.reflect.Type;
import java.util.Optional;
import org.javers.common.validation.Validate;
import org.javers.core.diff.changetype.PropertyChange;
import org.javers.core.diff.changetype.PropertyChangeMetadata;
import org.javers.core.diff.custom.CustomPropertyComparator;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.ClassType;
import org.javers.core.metamodel.type.CustomComparableType;
import org.javers.core.metamodel.type.CustomValueComparatorNullSafe;

public class CustomType<T>
extends ClassType
implements CustomComparableType {
    private final CustomPropertyComparatorNullSafe<T, ?> comparator;

    public CustomType(Type baseJavaType, CustomPropertyComparator<T, ?> comparator) {
        super(baseJavaType);
        Validate.argumentIsNotNull(comparator);
        this.comparator = new CustomPropertyComparatorNullSafe(comparator);
    }

    @Override
    public boolean equals(Object left, Object right) {
        return this.comparator.equals(left, right);
    }

    CustomPropertyComparator<T, ?> getComparator() {
        return this.comparator;
    }

    @Override
    public boolean hasCustomValueComparator() {
        return true;
    }

    @Override
    public String valueToString(Object value) {
        return this.comparator.toString(value);
    }

    private static class CustomPropertyComparatorNullSafe<T, C extends PropertyChange>
    extends CustomValueComparatorNullSafe<T>
    implements CustomPropertyComparator<T, C> {
        private final CustomPropertyComparator<T, C> delegate;

        public CustomPropertyComparatorNullSafe(CustomPropertyComparator<T, C> delegate) {
            super(delegate);
            this.delegate = delegate;
        }

        @Override
        public Optional<C> compare(T left, T right, PropertyChangeMetadata metadata, Property property) {
            return this.delegate.compare(left, right, metadata, property);
        }
    }
}

