/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.api;

import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.javers.common.validation.Validate;
import org.javers.core.commit.CommitId;
import org.javers.core.metamodel.object.SnapshotType;
import org.javers.repository.api.QueryParams;

public class QueryParamsBuilder {
    private int limit;
    private int skip;
    private LocalDateTime from;
    private Instant fromInstant;
    private LocalDateTime to;
    private Instant toInstant;
    private CommitId toCommitId;
    private Set<CommitId> commitIds = new HashSet<CommitId>();
    private Long version;
    private String author;
    private boolean aggregate;
    private Map<String, Collection<String>> commitProperties = new HashMap<String, Collection<String>>();
    private Map<String, String> commitPropertiesLike = new HashMap<String, String>();
    private Set<String> changedProperties = new HashSet<String>();
    private SnapshotType snapshotType;
    private boolean loadCommitProps = true;
    private Integer snapshotQueryLimit;

    public static QueryParamsBuilder copy(QueryParams that) {
        QueryParamsBuilder copy = new QueryParamsBuilder(that.limit()).skip(that.skip());
        that.from().ifPresent(it -> copy.from((LocalDateTime)it));
        that.to().ifPresent(it -> copy.to((LocalDateTime)it));
        that.fromInstant().ifPresent(it -> copy.fromInstant((Instant)it));
        that.toInstant().ifPresent(it -> copy.toInstant((Instant)it));
        that.toCommitId().ifPresent(it -> copy.toCommitId((CommitId)it));
        copy.commitIds = that.commitIds();
        that.version().ifPresent(it -> copy.version((Long)it));
        that.author().ifPresent(it -> copy.author((String)it));
        copy.withChildValueObjects(that.isAggregate());
        copy.commitProperties = that.commitProperties();
        copy.commitPropertiesLike = that.commitPropertiesLike();
        copy.changedProperties = that.changedProperties();
        that.snapshotType().ifPresent(it -> copy.withSnapshotType((SnapshotType)((Object)it)));
        copy.loadCommitProps = that.isLoadCommitProps();
        that.snapshotQueryLimit().ifPresent(it -> copy.snapshotQueryLimit((Integer)it));
        return copy;
    }

    private QueryParamsBuilder(int limit) {
        this.limit = limit;
        this.skip = 0;
    }

    public static QueryParamsBuilder withLimit(int limit) {
        QueryParamsBuilder.checkLimit(limit);
        return new QueryParamsBuilder(limit);
    }

    public QueryParamsBuilder snapshotQueryLimit(Integer snapshotQueryLimit) {
        this.snapshotQueryLimit = snapshotQueryLimit;
        return this;
    }

    public QueryParamsBuilder withChildValueObjects(boolean aggregate) {
        this.aggregate = aggregate;
        return this;
    }

    public QueryParamsBuilder withCommitProps(boolean loadCommitProps) {
        this.loadCommitProps = loadCommitProps;
        return this;
    }

    public QueryParamsBuilder limit(int limit) {
        QueryParamsBuilder.checkLimit(limit);
        this.limit = limit;
        return this;
    }

    public QueryParamsBuilder skip(int skip) {
        Validate.argumentCheck(skip >= 0, "Skip is not a non-negative number.");
        this.skip = skip;
        return this;
    }

    public QueryParamsBuilder from(LocalDateTime from) {
        this.from = from;
        return this;
    }

    public QueryParamsBuilder fromInstant(Instant fromInstant) {
        this.fromInstant = fromInstant;
        return this;
    }

    public QueryParamsBuilder to(LocalDateTime to) {
        this.to = to;
        return this;
    }

    public QueryParamsBuilder toInstant(Instant toInstant) {
        this.toInstant = toInstant;
        return this;
    }

    public QueryParamsBuilder commitId(CommitId commitId) {
        this.commitIds.add(commitId);
        return this;
    }

    public QueryParamsBuilder toCommitId(CommitId toCommitId) {
        this.toCommitId = toCommitId;
        return this;
    }

    public QueryParamsBuilder commitIds(Collection<CommitId> commitIds) {
        if (commitIds != null) {
            this.commitIds.addAll(commitIds);
        }
        return this;
    }

    public QueryParamsBuilder commitProperty(String name, String value) {
        this.commitProperties.put(name, Collections.singletonList(value));
        return this;
    }

    public QueryParamsBuilder commitPropertyIn(String name, Collection<String> value) {
        this.commitProperties.put(name, value);
        return this;
    }

    public QueryParamsBuilder commitPropertyLike(String name, String value) {
        this.commitPropertiesLike.put(name, value);
        return this;
    }

    public QueryParamsBuilder version(Long version) {
        this.version = version;
        return this;
    }

    public QueryParamsBuilder withSnapshotType(SnapshotType snapshotType) {
        this.snapshotType = snapshotType;
        return this;
    }

    public QueryParamsBuilder changedProperties(Collection<String> propertyNames) {
        this.changedProperties.addAll(propertyNames);
        return this;
    }

    public QueryParamsBuilder author(String author) {
        this.author = author;
        return this;
    }

    private static void checkLimit(int limit) {
        Validate.argumentCheck(limit > 0, "Limit is not a positive number.");
    }

    public QueryParams build() {
        return new QueryParams(this.limit, this.skip, this.from, this.fromInstant, this.to, this.toInstant, this.commitIds, this.version, this.author, this.commitProperties, this.commitPropertiesLike, this.aggregate, this.changedProperties, this.toCommitId, this.snapshotType, this.loadCommitProps, this.snapshotQueryLimit);
    }
}

