/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.changetype;

import java.util.Objects;
import java.util.Optional;
import org.javers.core.diff.Change;
import org.javers.core.diff.changetype.PropertyChangeMetadata;
import org.javers.core.diff.changetype.PropertyChangeType;
import org.javers.core.metamodel.object.ValueObjectId;

public abstract class PropertyChange
extends Change {
    private final PropertyChangeType changeType;
    private final String propertyName;

    protected PropertyChange(PropertyChangeMetadata propertyChangeMetadata) {
        super(propertyChangeMetadata.getAffectedCdoId(), Optional.empty(), propertyChangeMetadata.getCommitMetadata());
        this.propertyName = propertyChangeMetadata.getPropertyName();
        this.changeType = propertyChangeMetadata.getChangeType();
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getPropertyNameWithPath() {
        if (this.getAffectedGlobalId() instanceof ValueObjectId) {
            return ((ValueObjectId)this.getAffectedGlobalId()).getFragment() + "." + this.propertyName;
        }
        return this.propertyName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof PropertyChange) {
            PropertyChange that = (PropertyChange)o;
            return super.equals(that) && Objects.equals(this.propertyName, that.propertyName);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.propertyName);
    }

    public PropertyChangeType getChangeType() {
        return this.changeType;
    }

    public boolean isPropertyAdded() {
        return this.changeType == PropertyChangeType.PROPERTY_ADDED;
    }

    public boolean isPropertyRemoved() {
        return this.changeType == PropertyChangeType.PROPERTY_REMOVED;
    }

    public boolean isPropertyValueChanged() {
        return this.changeType == PropertyChangeType.PROPERTY_VALUE_CHANGED;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{ property: '" + this.propertyName + "' }";
    }
}

