/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.appenders;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.javers.common.collections.Maps;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.core.diff.NodePair;
import org.javers.core.diff.appenders.CorePropertyChangeAppender;
import org.javers.core.diff.appenders.HashWrapper;
import org.javers.core.diff.appenders.PropertyChangeAppender;
import org.javers.core.diff.changetype.map.EntryAdded;
import org.javers.core.diff.changetype.map.EntryChange;
import org.javers.core.diff.changetype.map.EntryRemoved;
import org.javers.core.diff.changetype.map.EntryValueChange;
import org.javers.core.diff.changetype.map.MapChange;
import org.javers.core.metamodel.type.JaversProperty;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.MapType;
import org.javers.core.metamodel.type.ValueObjectType;

class MapChangeAppender
implements PropertyChangeAppender<MapChange> {
    MapChangeAppender() {
    }

    @Override
    public boolean supports(JaversType propertyType) {
        if (!(propertyType instanceof MapType)) {
            return false;
        }
        MapType mapType = (MapType)propertyType;
        if (mapType.getKeyJaversType() instanceof ValueObjectType) {
            throw new JaversException(JaversExceptionCode.VALUE_OBJECT_IS_NOT_SUPPORTED_AS_MAP_KEY, propertyType);
        }
        return true;
    }

    @Override
    public MapChange calculateChanges(NodePair pair, JaversProperty property) {
        Map right;
        MapType mapType = (MapType)property.getType();
        Map left = this.wrapKeysIfNeeded((Map)pair.getLeftDehydratedPropertyValueAndSanitize(property), mapType.getKeyJaversType());
        List<EntryChange> changes = this.calculateEntryChanges(left, right = this.wrapKeysIfNeeded((Map)pair.getRightDehydratedPropertyValueAndSanitize(property), mapType.getKeyJaversType()), mapType.getValueJaversType());
        if (!changes.isEmpty()) {
            CorePropertyChangeAppender.renderNotParametrizedWarningIfNeeded(mapType.getKeyJavaType(), "key", "Map", property);
            CorePropertyChangeAppender.renderNotParametrizedWarningIfNeeded(mapType.getValueJavaType(), "value", "Map", property);
            return new MapChange(pair.createPropertyChangeMetadata(property), changes);
        }
        return null;
    }

    private Map wrapKeysIfNeeded(Map map, JaversType mapKeyType) {
        return HashWrapper.wrapKeysIfNeeded(map, mapKeyType);
    }

    List<EntryChange> calculateEntryChanges(Map leftMap, Map rightMap, JaversType mapValueType) {
        ArrayList<EntryChange> changes = new ArrayList<EntryChange>();
        for (Object commonKey : Maps.commonKeys(leftMap, rightMap)) {
            Object rightVal;
            Object leftVal = leftMap.get(commonKey);
            if (mapValueType.equals(leftVal, rightVal = rightMap.get(commonKey))) continue;
            changes.add(new EntryValueChange(commonKey, leftVal, rightVal));
        }
        for (Object addedKey : Maps.keysDifference(rightMap, leftMap)) {
            Object addedValue = rightMap.get(addedKey);
            changes.add(new EntryAdded(addedKey, addedValue));
        }
        for (Object removedKey : Maps.keysDifference(leftMap, rightMap)) {
            Object removedValue = leftMap.get(removedKey);
            changes.add(new EntryRemoved(removedKey, removedValue));
        }
        return changes;
    }
}

