/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.appenders;

import java.util.List;
import org.javers.common.collections.Lists;
import org.javers.core.diff.NodePair;
import org.javers.core.diff.appenders.CorePropertyChangeAppender;
import org.javers.core.diff.appenders.MapChangeAppender;
import org.javers.core.diff.appenders.MapChangesToListChangesFunction;
import org.javers.core.diff.changetype.container.ContainerElementChange;
import org.javers.core.diff.changetype.container.ListChange;
import org.javers.core.diff.changetype.map.EntryChange;
import org.javers.core.metamodel.type.CollectionType;
import org.javers.core.metamodel.type.JaversProperty;

abstract class ListToMapAppenderAdapter
extends CorePropertyChangeAppender<ListChange> {
    private final MapChangeAppender mapChangeAppender;

    ListToMapAppenderAdapter(MapChangeAppender mapChangeAppender) {
        this.mapChangeAppender = mapChangeAppender;
    }

    ListChange calculateChangesInList(List leftList, List rightList, NodePair pair, JaversProperty property) {
        CollectionType listType = (CollectionType)property.getType();
        List<EntryChange> entryChanges = this.mapChangeAppender.calculateEntryChanges(Lists.asMap(leftList), Lists.asMap(rightList), listType.getItemJaversType());
        if (!entryChanges.isEmpty()) {
            List<ContainerElementChange> elementChanges = Lists.transform(entryChanges, new MapChangesToListChangesFunction());
            ListToMapAppenderAdapter.renderNotParametrizedWarningIfNeeded(listType.getItemJavaType(), "item", "List", property);
            return new ListChange(pair.createPropertyChangeMetadata(property), elementChanges);
        }
        return null;
    }
}

