/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.List;
import org.javers.common.collections.Lists;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.type.ArrayType;
import org.javers.core.metamodel.type.ClassType;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.ParametrizedDehydratedType;
import org.javers.core.metamodel.type.TypeMapper;

class DehydratedTypeFactory {
    private static Class GLOBAL_ID_ARRAY_TYPE = new GlobalId[0].getClass();
    private TypeMapper mapper;

    DehydratedTypeFactory(TypeMapper mapper) {
        this.mapper = mapper;
    }

    public Type build(Type givenType) {
        if (givenType instanceof TypeVariable) {
            return Object.class;
        }
        ClassType javersType = this.mapper.getJaversClassType(givenType);
        if (javersType.isGenericType()) {
            List<Type> actualDehydratedTypeArguments = this.extractAndDehydrateTypeArguments(javersType);
            return new ParametrizedDehydratedType(javersType.getBaseJavaClass(), actualDehydratedTypeArguments);
        }
        if (javersType instanceof ArrayType) {
            Type dehydratedItemType = this.build(javersType.getConcreteClassTypeArguments().get(0));
            if (dehydratedItemType == GlobalId.class) {
                return GLOBAL_ID_ARRAY_TYPE;
            }
            return givenType;
        }
        return javersType.getRawDehydratedType();
    }

    private List<Type> extractAndDehydrateTypeArguments(JaversType genericType) {
        return Lists.transform(genericType.getConcreteClassTypeArguments(), typeArgument -> this.build((Type)typeArgument));
    }
}

