/*
 * Decompiled with CFR 0.152.
 */
package org.javers.common.string;

import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.javers.common.string.ToStringBuilder;
import org.javers.core.JaversCoreProperties;

public class PrettyValuePrinter {
    private final Map<Class<? extends Temporal>, DateTimeFormatter> dateFormatters = new HashMap<Class<? extends Temporal>, DateTimeFormatter>();
    private static final PrettyValuePrinter defaultInstance = new PrettyValuePrinter(new JaversCoreProperties.PrettyPrintDateFormats());

    public static PrettyValuePrinter getDefault() {
        return defaultInstance;
    }

    public PrettyValuePrinter(JaversCoreProperties.PrettyPrintDateFormats prettyPrintDateFormats) {
        for (Class<? extends Temporal> classKey : prettyPrintDateFormats.getFormats().keySet()) {
            this.dateFormatters.put(classKey, DateTimeFormatter.ofPattern(prettyPrintDateFormats.getFormats().get(classKey)));
        }
    }

    public String formatWithQuotes(Object value) {
        return "'" + this.format(value) + "'";
    }

    public String format(Object value) {
        DateTimeFormatter formatter;
        if (value == null) {
            return "";
        }
        if (value instanceof TemporalAccessor && (formatter = this.dateFormatters.get(value.getClass())) != null) {
            return formatter.format((TemporalAccessor)value);
        }
        if (value instanceof Set) {
            return ToStringBuilder.setToString((Set)value);
        }
        if (value instanceof List) {
            return ToStringBuilder.listToString((List)value);
        }
        if (value instanceof Optional) {
            if (((Optional)value).isPresent()) {
                return this.format(((Optional)value).get());
            }
            return "empty";
        }
        return value.toString();
    }
}

