/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.appenders;

import java.lang.reflect.Type;
import org.javers.core.diff.NodePair;
import org.javers.core.diff.appenders.PropertyChangeAppender;
import org.javers.core.diff.changetype.PropertyChange;
import org.javers.core.metamodel.type.JaversProperty;
import org.javers.core.metamodel.type.JaversType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CorePropertyChangeAppender<T extends PropertyChange>
implements PropertyChangeAppender<T> {
    private static final Logger logger = LoggerFactory.getLogger(CorePropertyChangeAppender.class);
    public static final String GENERIC_TYPE_NOT_PARAMETRIZED = "GENERIC_TYPE_NOT_PARAMETRIZED";

    public static void renderNotParametrizedWarningIfNeeded(Type parameterType, String parameterName, String colType, JaversProperty property) {
        if (parameterType == JaversType.DEFAULT_TYPE_PARAMETER) {
            logger.warn("Unknown {} type in {} property: {}. Defaulting to {}, see {}.{}", new Object[]{parameterName, colType, property.toString(), JaversType.DEFAULT_TYPE_PARAMETER.getSimpleName(), CorePropertyChangeAppender.class.getSimpleName(), GENERIC_TYPE_NOT_PARAMETRIZED});
        }
    }

    @Override
    public final T calculateChanges(NodePair pair, JaversProperty property) {
        Object leftValue = pair.getLeftDehydratedPropertyValueAndSanitize(property);
        Object rightValue = pair.getRightDehydratedPropertyValueAndSanitize(property);
        return this.calculateChanges(leftValue, rightValue, pair, property);
    }

    protected abstract T calculateChanges(Object var1, Object var2, NodePair var3, JaversProperty var4);
}

