/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.pico;

import java.lang.reflect.Type;
import java.util.Collection;
import org.javers.common.reflection.ReflectionUtil;
import org.javers.core.pico.ContainerArgumentResolver;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.adapters.AbstractAdapter;

public abstract class InstantiatingModule {
    private final MutablePicoContainer container;
    private final ContainerArgumentResolver argumentResolver;

    public InstantiatingModule(MutablePicoContainer container) {
        this.container = container;
        this.argumentResolver = new ContainerArgumentResolver((PicoContainer)container);
    }

    public final void instantiateAndBindComponents() {
        for (Class implementation : this.getImplementations()) {
            ConstructorInjector constructorInjector = new ConstructorInjector(implementation);
            this.container.addAdapter((ComponentAdapter)constructorInjector);
        }
    }

    protected abstract Collection<Class> getImplementations();

    private class ConstructorInjector
    extends AbstractAdapter {
        public ConstructorInjector(Class componentImplementation) {
            this(componentImplementation, componentImplementation);
        }

        public ConstructorInjector(Object componentKey, Class componentImplementation) {
            super(componentKey, componentImplementation);
        }

        public Object getComponentInstance(PicoContainer pico, Type into) {
            return ReflectionUtil.newInstance(this.getComponentImplementation(), InstantiatingModule.this.argumentResolver);
        }

        public void verify(PicoContainer container) {
        }

        public String getDescriptor() {
            return this.getComponentKey().toString();
        }
    }
}

