/*
 * Decompiled with CFR 0.152.
 */
package org.javers.common.reflection;

import io.github.classgraph.ClassGraph;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.javers.common.collections.Lists;
import org.javers.common.collections.Sets;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.reflection.ArgumentResolver;
import org.javers.common.reflection.JaversField;
import org.javers.common.reflection.JaversFieldFactory;
import org.javers.common.reflection.JaversGetter;
import org.javers.common.reflection.JaversGetterFactory;
import org.javers.common.reflection.JaversMember;
import org.javers.common.validation.Validate;
import org.javers.core.Javers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionUtil {
    private static final Logger logger = LoggerFactory.getLogger(ReflectionUtil.class);

    public static boolean isClassPresent(String className) {
        try {
            Class.forName(className, false, Javers.class.getClassLoader());
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public static Class<?> classForName(String className) {
        try {
            return Class.forName(className, false, Javers.class.getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            throw new JaversException(ex);
        }
    }

    public static Object invokeGetter(Object target, String getterName) {
        Validate.argumentsAreNotNull(target, getterName);
        try {
            Method m = target.getClass().getMethod(getterName, new Class[0]);
            return m.invoke(target, new Object[0]);
        }
        catch (Exception e) {
            throw new JaversException(e);
        }
    }

    public static Object newInstance(Class clazz, ArgumentResolver resolver) {
        Validate.argumentIsNotNull(clazz);
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            if (ReflectionUtil.isPrivate(constructor) || ReflectionUtil.isProtected(constructor)) continue;
            Class<?>[] types = constructor.getParameterTypes();
            Object[] params = new Object[types.length];
            for (int i = 0; i < types.length; ++i) {
                try {
                    params[i] = resolver.resolve(types[i]);
                    continue;
                }
                catch (JaversException e) {
                    logger.error("failed to create new instance of " + clazz.getName() + ", argument resolver for arg[" + i + "] " + types[i].getName() + " thrown exception: " + e.getMessage());
                    throw e;
                }
            }
            try {
                constructor.setAccessible(true);
                return constructor.newInstance(params);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new JaversException(JaversExceptionCode.NO_PUBLIC_CONSTRUCTOR, clazz.getName());
    }

    public static List<JaversField> getAllPersistentFields(Class methodSource) {
        ArrayList<JaversField> result = new ArrayList<JaversField>();
        for (JaversField field : ReflectionUtil.getAllFields(methodSource)) {
            if (!ReflectionUtil.isPersistentField((Field)field.getRawMember())) continue;
            result.add(field);
        }
        return result;
    }

    public static List<JaversGetter> getAllGetters(Class methodSource) {
        JaversGetterFactory getterFactory = new JaversGetterFactory(methodSource);
        return getterFactory.getAllGetters();
    }

    public static List<JaversField> getAllFields(Class<?> methodSource) {
        JaversFieldFactory fieldFactory = new JaversFieldFactory(methodSource);
        return fieldFactory.getAllFields();
    }

    public static Optional<JaversMember> getMirrorMember(JaversMember member, Class methodSource) {
        if (member instanceof JaversGetter) {
            return ReflectionUtil.getMirrorGetter((JaversGetter)member, methodSource);
        }
        if (member instanceof JaversField) {
            return ReflectionUtil.getMirrorField((JaversField)member, methodSource);
        }
        throw new JaversException(JaversExceptionCode.NOT_IMPLEMENTED, new Object[0]);
    }

    public static Optional<JaversField> getMirrorField(JaversField field, Class methodSource) {
        return ReflectionUtil.getAllFields(methodSource).stream().filter(f -> f.propertyName().equals(field.propertyName())).findFirst();
    }

    public static Optional<JaversGetter> getMirrorGetter(JaversGetter getter, Class methodSource) {
        return ReflectionUtil.getAllGetters(methodSource).stream().filter(f -> f.propertyName().equals(getter.propertyName())).findFirst();
    }

    private static boolean isPersistentField(Field field) {
        return !Modifier.isTransient(field.getModifiers()) && !Modifier.isStatic(field.getModifiers()) && !field.getName().equals("this$0");
    }

    private static boolean isPrivate(Member member) {
        return Modifier.isPrivate(member.getModifiers());
    }

    private static boolean isProtected(Member member) {
        return Modifier.isProtected(member.getModifiers());
    }

    public static List<Type> getAllTypeArguments(Type javaType) {
        if (!(javaType instanceof ParameterizedType)) {
            return Collections.emptyList();
        }
        return Lists.immutableListOf(((ParameterizedType)javaType).getActualTypeArguments());
    }

    public static List<Class<?>> findClasses(Class<? extends Annotation> annotation, String ... packages) {
        Validate.argumentsAreNotNull(annotation, packages);
        return new ClassGraph().whitelistPackages(packages).enableAnnotationInfo().scan().getClassesWithAnnotation(annotation.getName()).loadClasses();
    }

    public static Optional<Type> isConcreteType(Type javaType) {
        WildcardType wildcardType;
        if (javaType instanceof Class || javaType instanceof ParameterizedType) {
            return Optional.of(javaType);
        }
        if (javaType instanceof WildcardType && (wildcardType = (WildcardType)javaType).getLowerBounds().length == 0) {
            for (Type type : wildcardType.getUpperBounds()) {
                if (type instanceof Class && ((Class)type).equals(Object.class)) continue;
                return Optional.of(type);
            }
        }
        return Optional.empty();
    }

    public static Class extractClass(Type javaType) {
        if (javaType instanceof ParameterizedType && ((ParameterizedType)javaType).getRawType() instanceof Class) {
            return (Class)((ParameterizedType)javaType).getRawType();
        }
        if (javaType instanceof GenericArrayType) {
            return Object[].class;
        }
        if (javaType instanceof Class) {
            return (Class)javaType;
        }
        throw new JaversException(JaversExceptionCode.CLASS_EXTRACTION_ERROR, javaType);
    }

    public static boolean isAnnotationPresentInHierarchy(Class<?> clazz, Class<? extends Annotation> ann) {
        for (Class<?> current = clazz; current != null && current != Object.class; current = current.getSuperclass()) {
            if (!current.isAnnotationPresent(ann)) continue;
            return true;
        }
        return false;
    }

    public static List<Type> calculateHierarchyDistance(Class<?> clazz) {
        ArrayList interfaces = new ArrayList();
        ArrayList<Type> parents = new ArrayList<Type>();
        for (Class<?> current = clazz; current != null && current != Object.class; current = current.getSuperclass()) {
            if (clazz != current) {
                parents.add(current);
            }
            for (Class<?> i : current.getInterfaces()) {
                if (interfaces.contains(i)) continue;
                interfaces.add(i);
            }
        }
        parents.addAll(interfaces);
        return parents;
    }

    public static String reflectiveToString(Object obj) {
        Validate.argumentIsNotNull(obj);
        StringBuilder ret = new StringBuilder();
        for (JaversField f : ReflectionUtil.getAllPersistentFields(obj.getClass())) {
            Object val = f.getEvenIfPrivate(obj);
            if (val != null) {
                ret.append(val.toString());
            }
            ret.append(",");
        }
        if (ret.length() == 0) {
            return obj.toString();
        }
        ret.delete(ret.length() - 1, ret.length());
        return ret.toString();
    }

    public static boolean isAssignableFromAny(Class clazz, List<Class<?>> assignableFrom) {
        for (Class<?> standardPrimitive : assignableFrom) {
            if (!standardPrimitive.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    public static <T> T getAnnotationValue(Annotation ann, String propertyName) {
        return (T)ReflectionUtil.invokeGetter(ann, propertyName);
    }

    public static boolean looksLikeId(Member member) {
        return ReflectionUtil.getAnnotations(member).stream().map(ann -> ann.annotationType().getSimpleName()).anyMatch(annName -> annName.equals("Id") || annName.equals("EmbeddedId"));
    }

    public static Set<Annotation> getAnnotations(Member member) {
        return Collections.unmodifiableSet(Sets.asSet(((AccessibleObject)((Object)member)).getAnnotations()));
    }
}

