/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.jql;

import org.javers.common.validation.Validate;
import org.javers.repository.jql.GlobalIdDTO;
import org.javers.repository.jql.InstanceIdDTO;
import org.javers.repository.jql.UnboundedValueObjectIdDTO;

public final class ValueObjectIdDTO
extends GlobalIdDTO {
    private final GlobalIdDTO ownerIdDTO;
    private final String path;

    ValueObjectIdDTO(Class ownerClass, Object ownerLocalId, String path) {
        Validate.argumentsAreNotNull(ownerClass, ownerLocalId, path);
        this.ownerIdDTO = InstanceIdDTO.instanceId(ownerLocalId, ownerClass);
        this.path = path;
    }

    ValueObjectIdDTO(Class ownerClass, String path) {
        Validate.argumentsAreNotNull(ownerClass, path);
        this.ownerIdDTO = UnboundedValueObjectIdDTO.unboundedValueObjectId(ownerClass);
        this.path = path;
    }

    public static ValueObjectIdDTO valueObjectId(Object ownerLocalId, Class ownerClass, String fragment) {
        return new ValueObjectIdDTO(ownerClass, ownerLocalId, fragment);
    }

    public static ValueObjectIdDTO withUnboundedValueObjectOwner(Class ownerClass, String fragment) {
        return new ValueObjectIdDTO(ownerClass, fragment);
    }

    @Override
    public String value() {
        return this.ownerIdDTO.value() + "#" + this.path;
    }

    public GlobalIdDTO getOwnerIdDTO() {
        return this.ownerIdDTO;
    }

    public String getPath() {
        return this.path;
    }
}

