/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.object;

import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.ValueObjectId;

public abstract class ValueObjectIdWithHash
extends ValueObjectId {
    private static final String HASH_PLACEHOLDER = "{hashPlaceholder}";

    private ValueObjectIdWithHash(String typeName, GlobalId ownerId, String fragment) {
        super(typeName, ownerId, fragment);
    }

    public abstract boolean requiresHash();

    public abstract boolean hasHashOnParent();

    public abstract ValueObjectId freeze(String var1);

    public abstract ValueObjectId freeze();

    @Override
    public String toString() {
        return this.getOwnerId().toString() + "#" + this.getFragment() + " (" + this.getClass().getSimpleName() + ")";
    }

    static class ValueObjectIdWithPlaceholderOnParent
    extends ValueObjectIdWithHash {
        private final ValueObjectIdWithHash parentId;
        private final String localPath;

        ValueObjectIdWithPlaceholderOnParent(String typeName, ValueObjectIdWithHash parentId, String localPath) {
            super(typeName, parentId.getOwnerId(), "{lazy}");
            this.parentId = parentId;
            this.localPath = localPath;
        }

        @Override
        public String getFragment() {
            return this.parentId.getFragment() + "/" + this.localPath;
        }

        @Override
        public boolean requiresHash() {
            return false;
        }

        @Override
        public boolean hasHashOnParent() {
            return true;
        }

        @Override
        public ValueObjectId freeze(String hash) {
            throw new JaversException(JaversExceptionCode.NOT_IMPLEMENTED, new Object[0]);
        }

        @Override
        public ValueObjectId freeze() {
            return new ValueObjectId(this.getTypeName(), this.getOwnerId(), this.getFragment());
        }
    }

    static class ValueObjectIdWithPlaceholder
    extends ValueObjectIdWithHash {
        private final String pathFromRoot;
        private String hash;

        ValueObjectIdWithPlaceholder(String typeName, GlobalId ownerId, String pathFromRoot) {
            super(typeName, ownerId, pathFromRoot + "/" + ValueObjectIdWithHash.HASH_PLACEHOLDER);
            this.pathFromRoot = pathFromRoot;
            this.hash = ValueObjectIdWithHash.HASH_PLACEHOLDER;
        }

        @Override
        public ValueObjectId freeze(String hash) {
            if (!ValueObjectIdWithHash.HASH_PLACEHOLDER.equals(this.hash)) {
                throw new JaversException(JaversExceptionCode.RUNTIME_EXCEPTION, "already frozen");
            }
            this.hash = hash;
            return new ValueObjectId(this.getTypeName(), this.getOwnerId(), this.getFragment());
        }

        @Override
        public boolean requiresHash() {
            return true;
        }

        @Override
        public boolean hasHashOnParent() {
            return false;
        }

        @Override
        public String getFragment() {
            return this.pathFromRoot + "/" + this.hash;
        }

        @Override
        public ValueObjectId freeze() {
            throw new JaversException(JaversExceptionCode.NOT_IMPLEMENTED, new Object[0]);
        }
    }
}

