/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.lang.reflect.Type;
import java.util.Optional;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.string.PrettyPrintBuilder;
import org.javers.common.string.ToStringBuilder;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.object.InstanceId;
import org.javers.core.metamodel.type.InstanceIdFactory;
import org.javers.core.metamodel.type.JaversProperty;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.ManagedClass;
import org.javers.core.metamodel.type.ManagedType;

public class EntityType
extends ManagedType {
    private final JaversProperty idProperty;
    private final InstanceIdFactory instanceIdFactory;

    EntityType(ManagedClass entity, JaversProperty idProperty, Optional<String> typeName) {
        super(entity, typeName);
        Validate.argumentIsNotNull(idProperty);
        this.idProperty = idProperty;
        this.instanceIdFactory = new InstanceIdFactory(this);
    }

    @Override
    EntityType spawn(ManagedClass managedClass, Optional<String> typeName) {
        return new EntityType(managedClass, managedClass.getProperty(this.idProperty.getName()), typeName);
    }

    public Type getIdPropertyGenericType() {
        return this.getIdProperty().getGenericType();
    }

    public JaversProperty getIdProperty() {
        return this.idProperty;
    }

    private String getIdPropertyName() {
        return this.getIdProperty().getName();
    }

    public boolean isIdProperty(JaversProperty property) {
        return this.idProperty.equals(property);
    }

    public Object getIdOf(Object instance) {
        Validate.argumentIsNotNull(instance);
        if (!this.isInstance(instance)) {
            throw new JaversException(JaversExceptionCode.NOT_INSTANCE_OF, this.getName(), this.getBaseJavaClass().getName(), instance.getClass().getName());
        }
        Object cdoId = this.getIdProperty().get(instance);
        if (cdoId == null) {
            throw new JaversException(JaversExceptionCode.ENTITY_INSTANCE_WITH_NULL_ID, this.getName(), this.getIdProperty().getName());
        }
        return cdoId;
    }

    public Type getLocalIdDehydratedType() {
        return this.instanceIdFactory.getLocalIdDehydratedType();
    }

    public InstanceId createIdFromInstance(Object instance) {
        Object localId = this.getIdOf(instance);
        return this.instanceIdFactory.create(localId);
    }

    public InstanceId createIdFromInstanceId(Object localId) {
        return this.instanceIdFactory.create(localId);
    }

    public InstanceId createIdFromDehydratedLocalId(Object dehydratedLocalId) {
        return this.instanceIdFactory.createFromDehydratedLocalId(dehydratedLocalId);
    }

    public <T extends JaversType> T getIdPropertyType() {
        return this.getIdProperty().getType();
    }

    InstanceIdFactory getInstanceIdFactory() {
        return this.instanceIdFactory;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntityType)) {
            return false;
        }
        EntityType that = (EntityType)o;
        return super.equals(that) && this.idProperty.equals(that.idProperty);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.idProperty.hashCode();
    }

    @Override
    public String toString() {
        return ToStringBuilder.toString(this, "baseType", this.getBaseJavaType(), "id", this.getIdPropertyName());
    }

    @Override
    protected PrettyPrintBuilder prettyPrintBuilder() {
        return super.prettyPrintBuilder().addField("idProperty", this.getIdPropertyName() + ", mapped to " + this.getIdPropertyType().getClass().getSimpleName());
    }
}

