/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.jql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.javers.common.collections.Consumer;
import org.javers.common.collections.Pair;
import org.javers.common.validation.Validate;
import org.javers.core.CommitIdGenerator;
import org.javers.core.JaversCoreConfiguration;
import org.javers.core.commit.CommitId;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.InstanceId;
import org.javers.core.metamodel.object.ValueObjectId;
import org.javers.repository.api.JaversExtendedRepository;
import org.javers.repository.api.QueryParams;
import org.javers.repository.api.QueryParamsBuilder;
import org.javers.repository.jql.JqlQuery;
import org.javers.repository.jql.QueryCompiler;
import org.javers.repository.jql.SnapshotQueryRunner;
import org.javers.shadow.Shadow;
import org.javers.shadow.ShadowFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ShadowQueryRunner {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.javers.JQL");
    private final QueryCompiler queryCompiler;
    private final SnapshotQueryRunner snapshotQueryRunner;
    private final JaversExtendedRepository repository;
    private final ShadowFactory shadowFactory;
    private final JaversCoreConfiguration javersCoreConfiguration;

    ShadowQueryRunner(QueryCompiler queryCompiler, SnapshotQueryRunner snapshotQueryRunner, JaversExtendedRepository repository, ShadowFactory shadowFactory, JaversCoreConfiguration javersCoreConfiguration) {
        this.queryCompiler = queryCompiler;
        this.snapshotQueryRunner = snapshotQueryRunner;
        this.repository = repository;
        this.shadowFactory = shadowFactory;
        this.javersCoreConfiguration = javersCoreConfiguration;
    }

    List<Shadow> queryForShadows(JqlQuery query) {
        return this.queryForShadows(query, Collections.emptyList()).left();
    }

    Pair<List<Shadow>, List<CdoSnapshot>> queryForShadows(JqlQuery query, List<CdoSnapshot> gapsFilledInPreviousQuery) {
        List<CdoSnapshot> coreSnapshots = this.queryForCoreSnapshots(query);
        CommitTable commitTable = new CommitTable(coreSnapshots, query.getMaxGapsToFill(), query);
        commitTable.appendSnapshots(gapsFilledInPreviousQuery);
        if (query.getShadowScope().isCommitDeep()) {
            commitTable.loadFullCommits();
        }
        List shadows = commitTable.rootsForQuery(query).stream().map(r -> this.shadowFactory.createShadow(r.root, r.context, (cm, targetId) -> commitTable.referenceResolver((CommitMetadata)cm, (GlobalId)targetId))).collect(Collectors.toList());
        query.stats().stop();
        logger.debug("queryForShadows executed: {}", (Object)query);
        return new Pair<List<Shadow>, List<CdoSnapshot>>(shadows, commitTable.getFilledGapsSnapshots());
    }

    private List<CdoSnapshot> queryForCoreSnapshots(JqlQuery query) {
        this.queryCompiler.compile(query);
        query.aggregateIfEntityQuery();
        List<CdoSnapshot> snapshots = this.snapshotQueryRunner.queryForSnapshots(query);
        query.stats().logShallowQuery(snapshots);
        return snapshots;
    }

    static class SnapshotReference {
        private final CommitMetadata timepoint;
        private final GlobalId targetId;

        SnapshotReference(CommitMetadata rootContext, GlobalId targetId) {
            Validate.argumentsAreNotNull(rootContext, targetId);
            this.timepoint = rootContext;
            this.targetId = targetId;
        }

        CommitMetadata timepoint() {
            return this.timepoint;
        }

        GlobalId targetId() {
            return this.targetId;
        }

        CommitId timepointCommitId() {
            return this.timepoint.getId();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SnapshotReference that = (SnapshotReference)o;
            return Objects.equals(this.timepointCommitId(), this.timepointCommitId()) && Objects.equals(this.targetId, that.targetId);
        }

        public int hashCode() {
            return Objects.hash(this.timepointCommitId(), this.targetId);
        }
    }

    private static class CommitEntry {
        private final CommitMetadata commitMetadata;
        private final Map<GlobalId, CdoSnapshot> entities = new HashMap<GlobalId, CdoSnapshot>();
        private final Map<ValueObjectId, CdoSnapshot> valueObjects = new HashMap<ValueObjectId, CdoSnapshot>();

        CommitEntry(CommitMetadata commitMetadata) {
            this.commitMetadata = commitMetadata;
        }

        void append(CdoSnapshot snapshot) {
            if (snapshot.getGlobalId() instanceof InstanceId) {
                this.entities.put(snapshot.getGlobalId(), snapshot);
            }
            if (snapshot.getGlobalId() instanceof ValueObjectId) {
                this.valueObjects.put((ValueObjectId)snapshot.getGlobalId(), snapshot);
            }
        }

        CdoSnapshot getAny(GlobalId globalId) {
            if (this.entities.containsKey(globalId)) {
                return this.entities.get(globalId);
            }
            return this.valueObjects.get(globalId);
        }

        Collection<CdoSnapshot> getEntities() {
            return this.entities.values();
        }

        Stream<CdoSnapshot> getAllStream() {
            return Stream.concat(this.valueObjects.values().stream(), this.entities.values().stream());
        }

        Set<GlobalId> getMissingParents() {
            Set<GlobalId> result = this.valueObjects.keySet().stream().map(voId -> voId.getOwnerId()).filter(instanceId -> !this.entities.containsKey(instanceId)).collect(Collectors.toSet());
            result.addAll(this.valueObjects.keySet().stream().flatMap(voId -> voId.getParentValueObjectIds().stream()).filter(voId -> !this.valueObjects.containsKey(voId)).collect(Collectors.toSet()));
            return result;
        }
    }

    private class CommitTable {
        private final int maxGapsToFill;
        private final Map<CommitMetadata, CommitEntry> commitsMap;
        private final JqlQuery query;
        private int filledGapsCount;
        private final List<CdoSnapshot> filledGapsSnapshots = new ArrayList<CdoSnapshot>();

        CommitTable(List<CdoSnapshot> coreSnapshots, int maxGapsToFill, JqlQuery query) {
            this.maxGapsToFill = maxGapsToFill;
            this.query = query;
            this.commitsMap = new TreeMap<CommitMetadata, CommitEntry>(ShadowQueryRunner.this.javersCoreConfiguration.getCommitIdGenerator().getComparator());
            this.appendSnapshots(coreSnapshots);
        }

        List<ShadowRoot> rootsForQuery(JqlQuery query) {
            this.fillMissingParents();
            ArrayList orderedCommits = new ArrayList();
            this.commitsMap.values().forEach(it -> orderedCommits.add(0, it));
            return orderedCommits.stream().flatMap(e -> e.getAllStream().filter(s -> query.matches(s.getGlobalId())).map(s -> new ShadowRoot(((CommitEntry)e).commitMetadata, (CdoSnapshot)s))).collect(Collectors.toList());
        }

        void loadFullCommits() {
            if (this.commitsMap.isEmpty()) {
                return;
            }
            QueryParams params = QueryParamsBuilder.withLimit(Integer.MAX_VALUE).commitIds(this.commitsMap.keySet().stream().map(it -> it.getId()).collect(Collectors.toSet())).build();
            List<CdoSnapshot> fullCommitsSnapshots = ShadowQueryRunner.this.repository.getSnapshots(params);
            this.query.stats().logQueryInCommitDeepScope(fullCommitsSnapshots);
            this.appendSnapshots(fullCommitsSnapshots);
        }

        CdoSnapshot referenceResolver(CommitMetadata rootContext, GlobalId targetId) {
            SnapshotReference reference = new SnapshotReference(rootContext, targetId);
            if (!this.commitsMap.containsKey(rootContext)) {
                return null;
            }
            CdoSnapshot latest = this.findLatestToInCommitTable(reference);
            if (latest == null) {
                this.appendSnapshots(this.fillGapFromRepository(reference, 15));
            }
            if ((latest = this.findLatestToInCommitTable(reference)) == null) {
                this.query.stats().logMaxGapsToFillExceededInfo(targetId);
            }
            return latest;
        }

        List<CdoSnapshot> getFilledGapsSnapshots() {
            return this.filledGapsSnapshots;
        }

        private CdoSnapshot findLatestToInCommitTable(SnapshotReference reference) {
            ArrayList found = new ArrayList();
            this.iterateUntil(ce -> {
                if (ce.getAny(reference.targetId()) != null) {
                    found.add(ce.getAny(reference.targetId()));
                }
            }, reference.timepointCommitId());
            if (found.size() == 0) {
                return null;
            }
            return (CdoSnapshot)found.get(found.size() - 1);
        }

        private boolean isInChildValueObjectScope(SnapshotReference snapshotReference) {
            return this.query.isAggregate() && snapshotReference.targetId() instanceof ValueObjectId;
        }

        List<CdoSnapshot> fillGapFromRepository(SnapshotReference snapshotReference, int limit) {
            List<CdoSnapshot> historicals;
            if (this.filledGapsCount >= this.maxGapsToFill && !this.isInChildValueObjectScope(snapshotReference)) {
                return Collections.emptyList();
            }
            if (this.isInChildValueObjectScope(snapshotReference)) {
                historicals = this.getHistoricals(snapshotReference.targetId(), snapshotReference, false, limit);
                this.query.stats().logQueryInChildValueObjectScope(snapshotReference.targetId(), snapshotReference.timepointCommitId(), historicals.size());
            } else {
                historicals = this.getHistoricals(snapshotReference.targetId(), snapshotReference, this.query.isAggregate(), limit);
                this.query.stats().logQueryInDeepPlusScope(snapshotReference.targetId(), snapshotReference.timepointCommitId(), historicals.size());
            }
            ++this.filledGapsCount;
            this.filledGapsSnapshots.addAll(historicals);
            return historicals;
        }

        private List<CdoSnapshot> getHistoricals(GlobalId globalId, SnapshotReference timePoint, boolean withChildValueObjects, int limit) {
            if (ShadowQueryRunner.this.javersCoreConfiguration.getCommitIdGenerator() == CommitIdGenerator.SYNCHRONIZED_SEQUENCE) {
                return ShadowQueryRunner.this.repository.getHistoricals(globalId, timePoint.timepointCommitId(), withChildValueObjects, limit);
            }
            return ShadowQueryRunner.this.repository.getHistoricals(globalId, timePoint.timepoint().getCommitDate(), withChildValueObjects, limit);
        }

        void fillMissingParents() {
            HashMap movingLatest = new HashMap();
            this.commitsMap.values().forEach(commitEntry -> {
                commitEntry.getMissingParents().stream().filter(movingLatest::containsKey).forEach(voId -> commitEntry.append((CdoSnapshot)movingLatest.get(voId)));
                commitEntry.getAllStream().forEach(e -> movingLatest.put(e.getGlobalId(), e));
            });
        }

        void appendSnapshots(Collection<CdoSnapshot> snapshots) {
            snapshots.forEach(it -> this.appendSnapshot((CdoSnapshot)it));
        }

        CommitEntry appendSnapshot(CdoSnapshot snapshot) {
            CommitEntry entry = this.commitsMap.get(snapshot.getCommitMetadata());
            if (entry == null) {
                entry = new CommitEntry(snapshot.getCommitMetadata());
                this.commitsMap.put(snapshot.getCommitMetadata(), entry);
            }
            entry.append(snapshot);
            return entry;
        }

        void iterateUntil(Consumer<CommitEntry> consumer, CommitId bound) {
            for (CommitEntry ce : this.commitsMap.values()) {
                consumer.consume(ce);
                if (!ce.commitMetadata.getId().equals(bound)) continue;
                break;
            }
        }
    }

    private static class ShadowRoot {
        final CommitMetadata context;
        final CdoSnapshot root;

        ShadowRoot(CdoSnapshot root) {
            this.context = root.getCommitMetadata();
            this.root = root;
        }

        ShadowRoot(CommitMetadata context, CdoSnapshot root) {
            this.context = context;
            this.root = root;
        }
    }
}

