/*
 * Decompiled with CFR 0.152.
 */
package org.javers.guava;

import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.util.ArrayList;
import java.util.List;
import org.javers.core.diff.NodePair;
import org.javers.core.diff.appenders.CorePropertyChangeAppender;
import org.javers.core.diff.appenders.PropertyChangeAppender;
import org.javers.core.diff.changetype.container.ContainerElementChange;
import org.javers.core.diff.changetype.container.SetChange;
import org.javers.core.diff.changetype.container.ValueAdded;
import org.javers.core.diff.changetype.container.ValueRemoved;
import org.javers.core.metamodel.object.OwnerContext;
import org.javers.core.metamodel.object.PropertyOwnerContext;
import org.javers.core.metamodel.type.JaversProperty;
import org.javers.core.metamodel.type.JaversType;
import org.javers.guava.MultisetType;

class MultisetChangeAppender
implements PropertyChangeAppender<SetChange> {
    MultisetChangeAppender() {
    }

    @Override
    public boolean supports(JaversType propertyType) {
        return propertyType instanceof MultisetType;
    }

    @Override
    public SetChange calculateChanges(NodePair pair, JaversProperty property) {
        PropertyOwnerContext owner;
        Multiset left = (Multiset)pair.getLeftDehydratedPropertyValueAndSanitize(property);
        Multiset right = (Multiset)pair.getRightDehydratedPropertyValueAndSanitize(property);
        MultisetType multisetType = (MultisetType)property.getType();
        List<ContainerElementChange> entryChanges = this.calculateEntryChanges(multisetType, left, right, owner = new PropertyOwnerContext(pair.getGlobalId(), property.getName()));
        if (!entryChanges.isEmpty()) {
            CorePropertyChangeAppender.renderNotParametrizedWarningIfNeeded(multisetType.getItemType(), "item", "Multiset", property);
            return new SetChange(pair.getGlobalId(), property.getName(), entryChanges);
        }
        return null;
    }

    private List<ContainerElementChange> calculateEntryChanges(MultisetType multisetType, Multiset left, Multiset right, OwnerContext owner) {
        ArrayList<ContainerElementChange> changes = new ArrayList<ContainerElementChange>();
        for (Object globalCdoId : Multisets.difference((Multiset)left, (Multiset)right)) {
            changes.add(new ValueRemoved(globalCdoId));
        }
        Multiset difference = Multisets.difference((Multiset)right, (Multiset)left);
        for (Object globalCdoId : difference) {
            changes.add(new ValueAdded(globalCdoId));
        }
        return changes;
    }
}

