/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.appenders;

import java.util.List;
import org.javers.common.collections.Lists;
import org.javers.core.diff.appenders.CorePropertyChangeAppender;
import org.javers.core.diff.appenders.MapChangeAppender;
import org.javers.core.diff.appenders.MapChangesToListChangesFunction;
import org.javers.core.diff.changetype.container.ContainerElementChange;
import org.javers.core.diff.changetype.container.ListChange;
import org.javers.core.diff.changetype.map.EntryChange;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.type.CollectionType;
import org.javers.core.metamodel.type.JaversProperty;
import org.javers.core.metamodel.type.MapContentType;
import org.javers.core.metamodel.type.TypeMapper;

abstract class ListToMapAppenderAdapter
extends CorePropertyChangeAppender<ListChange> {
    private final MapChangeAppender mapChangeAppender;
    private final TypeMapper typeMapper;

    ListToMapAppenderAdapter(MapChangeAppender mapChangeAppender, TypeMapper typeMapper) {
        this.mapChangeAppender = mapChangeAppender;
        this.typeMapper = typeMapper;
    }

    ListChange calculateChanges(List leftList, List rightList, GlobalId affectedId, JaversProperty property) {
        CollectionType listType = (CollectionType)property.getType();
        MapContentType mapContentType = this.typeMapper.getMapContentType(listType);
        List<EntryChange> entryChanges = this.mapChangeAppender.calculateEntryChanges(Lists.asMap(leftList), Lists.asMap(rightList), mapContentType);
        if (!entryChanges.isEmpty()) {
            List<ContainerElementChange> elementChanges = Lists.transform(entryChanges, new MapChangesToListChangesFunction());
            ListToMapAppenderAdapter.renderNotParametrizedWarningIfNeeded(listType.getItemType(), "item", "List", property);
            return new ListChange(affectedId, property.getName(), elementChanges);
        }
        return null;
    }
}

