/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import org.javers.common.collections.Sets;
import org.javers.core.graph.ObjectGraph;
import org.javers.core.graph.ObjectNode;

public class GraphPair {
    private final ObjectGraph leftGraph;
    private final ObjectGraph rightGraph;
    private final Collection<ObjectNode> onlyOnLeft;
    private final Collection<ObjectNode> onlyOnRight;

    public GraphPair(ObjectGraph leftGraph, ObjectGraph rightGraph) {
        this.leftGraph = leftGraph;
        this.rightGraph = rightGraph;
        Function<ObjectNode, Integer> hasher = objectNode -> objectNode.cdoHashCode();
        this.onlyOnLeft = Sets.difference(leftGraph.nodes(), rightGraph.nodes(), hasher);
        this.onlyOnRight = Sets.difference(rightGraph.nodes(), leftGraph.nodes(), hasher);
    }

    public GraphPair(ObjectGraph currentGraph) {
        this.leftGraph = new EmptyGraph();
        this.rightGraph = currentGraph;
        this.onlyOnLeft = Collections.emptySet();
        this.onlyOnRight = this.rightGraph.nodes();
    }

    public Collection<ObjectNode> getOnlyOnLeft() {
        return this.onlyOnLeft;
    }

    public Collection<ObjectNode> getOnlyOnRight() {
        return this.onlyOnRight;
    }

    public Set<ObjectNode> getLeftNodeSet() {
        return this.leftGraph.nodes();
    }

    public Set<ObjectNode> getRightNodeSet() {
        return this.rightGraph.nodes();
    }

    private class EmptyGraph
    extends ObjectGraph {
        EmptyGraph() {
            super(Collections.emptySet());
        }
    }
}

