/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.snapshot;

import java.util.Objects;
import org.javers.common.collections.Defaults;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.graph.Cdo;
import org.javers.core.graph.LiveNode;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.CdoSnapshotBuilder;
import org.javers.core.metamodel.object.CdoSnapshotState;
import org.javers.core.metamodel.object.CdoSnapshotStateBuilder;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.SnapshotType;
import org.javers.core.metamodel.type.JaversProperty;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.TypeMapper;

public class SnapshotFactory {
    private final TypeMapper typeMapper;

    SnapshotFactory(TypeMapper typeMapper) {
        this.typeMapper = typeMapper;
    }

    public CdoSnapshot createTerminal(GlobalId globalId, CdoSnapshot previous, CommitMetadata commitMetadata) {
        ManagedType managedType = this.typeMapper.getJaversManagedType(globalId);
        return CdoSnapshotBuilder.cdoSnapshot().withGlobalId(globalId).withManagedType(managedType).withCommitMetadata(commitMetadata).withType(SnapshotType.TERMINAL).withVersion(previous.getVersion() + 1L).build();
    }

    CdoSnapshot createInitial(LiveNode liveNode, CommitMetadata commitMetadata) {
        return this.initSnapshotBuilder(liveNode, commitMetadata).withState(this.createSnapshotState(liveNode)).withType(SnapshotType.INITIAL).markAllAsChanged().withVersion(1L).build();
    }

    CdoSnapshot createUpdate(LiveNode liveNode, CdoSnapshot previous, CommitMetadata commitMetadata) {
        return this.initSnapshotBuilder(liveNode, commitMetadata).withState(this.createSnapshotState(liveNode)).withType(SnapshotType.UPDATE).markChanged(previous).withVersion(previous.getVersion() + 1L).build();
    }

    public CdoSnapshotState createSnapshotStateNoRefs(Cdo liveCdo) {
        CdoSnapshotStateBuilder stateBuilder = CdoSnapshotStateBuilder.cdoSnapshotState();
        for (JaversProperty property : liveCdo.getManagedType().getProperties()) {
            Object propertyValue;
            if (property.getType() instanceof ManagedType || Objects.equals(propertyValue = liveCdo.getPropertyValue(property), Defaults.defaultValue(property.getGenericType()))) continue;
            stateBuilder.withPropertyValue(property, propertyValue);
        }
        return stateBuilder.build();
    }

    public CdoSnapshotState createSnapshotState(LiveNode liveNode) {
        CdoSnapshotStateBuilder stateBuilder = CdoSnapshotStateBuilder.cdoSnapshotState();
        for (JaversProperty property : liveNode.getManagedType().getProperties()) {
            Object dehydratedPropertyValue = liveNode.getDehydratedPropertyValue(property);
            if (Objects.equals(dehydratedPropertyValue, Defaults.defaultValue(property.getGenericType()))) continue;
            stateBuilder.withPropertyValue(property, dehydratedPropertyValue);
        }
        return stateBuilder.build();
    }

    private CdoSnapshotBuilder initSnapshotBuilder(LiveNode liveNode, CommitMetadata commitMetadata) {
        return CdoSnapshotBuilder.cdoSnapshot().withGlobalId(liveNode.getGlobalId()).withCommitMetadata(commitMetadata).withManagedType(liveNode.getManagedType());
    }
}

