/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.graph;

import java.util.List;
import java.util.Optional;
import org.javers.common.collections.Lists;
import org.javers.core.graph.LazyCdoWrapper;
import org.javers.core.graph.LiveCdo;
import org.javers.core.graph.LiveCdoWrapper;
import org.javers.core.graph.ObjectAccessHook;
import org.javers.core.graph.ObjectAccessProxy;
import org.javers.core.graph.ObjectHasher;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.GlobalIdFactory;
import org.javers.core.metamodel.object.OwnerContext;
import org.javers.core.metamodel.object.ValueObjectId;
import org.javers.core.metamodel.object.ValueObjectIdWithHash;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.TypeMapper;

public class LiveCdoFactory {
    private final GlobalIdFactory globalIdFactory;
    private ObjectAccessHook objectAccessHook;
    private TypeMapper typeMapper;
    private ObjectHasher objectHasher;

    LiveCdoFactory(GlobalIdFactory globalIdFactory, ObjectAccessHook objectAccessHook, TypeMapper typeMapper, ObjectHasher objectHasher) {
        this.globalIdFactory = globalIdFactory;
        this.objectAccessHook = objectAccessHook;
        this.typeMapper = typeMapper;
        this.objectHasher = objectHasher;
    }

    ValueObjectId regenerateValueObjectHash(LiveCdo valueObject, List<LiveCdo> descendantVOs) {
        List<LiveCdo> objectsToBeHashed = Lists.immutableListOf(descendantVOs, valueObject);
        String newHash = this.objectHasher.hash(objectsToBeHashed);
        ValueObjectIdWithHash id = (ValueObjectIdWithHash)valueObject.getGlobalId();
        return id.freeze(newHash);
    }

    LiveCdo create(Object cdo, OwnerContext owner) {
        GlobalId globalId = this.globalIdFactory.createId(cdo, owner);
        Optional<ObjectAccessProxy<Object>> objectAccessor = this.objectAccessHook.createAccessor(cdo);
        Class<?> targetClass = objectAccessor.map(p -> p.getTargetClass()).orElse(cdo.getClass());
        ManagedType managedType = this.typeMapper.getJaversManagedType(targetClass);
        if (objectAccessor.isPresent()) {
            return new LazyCdoWrapper(objectAccessor.get().getObjectSupplier(), globalId, managedType);
        }
        return new LiveCdoWrapper(cdo, globalId, managedType);
    }

    GlobalIdFactory getGlobalIdFactory() {
        return this.globalIdFactory;
    }
}

