/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.api;

import java.time.LocalDateTime;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.javers.common.string.ToStringBuilder;
import org.javers.core.commit.CommitId;
import org.javers.core.metamodel.object.SnapshotType;

public class QueryParams {
    private final int limit;
    private final int skip;
    private final LocalDateTime from;
    private final LocalDateTime to;
    private final CommitId toCommitId;
    private final Set<CommitId> commitIds;
    private final Long version;
    private final String author;
    private final Map<String, String> commitProperties;
    private final boolean aggregate;
    private final boolean newObjectChanges;
    private final String changedProperty;
    private final SnapshotType snapshotType;
    private final boolean loadCommitProps;

    QueryParams(int limit, int skip, LocalDateTime from, LocalDateTime to, Set<CommitId> commitIds, Long version, String author, Map<String, String> commitProperties, boolean aggregate, boolean newObjectChanges, String changedProperty, CommitId toCommitId, SnapshotType snapshotType, boolean loadCommitProps) {
        this.limit = limit;
        this.skip = skip;
        this.from = from;
        this.to = to;
        this.commitIds = commitIds;
        this.version = version;
        this.author = author;
        this.commitProperties = commitProperties;
        this.aggregate = aggregate;
        this.newObjectChanges = newObjectChanges;
        this.changedProperty = changedProperty;
        this.toCommitId = toCommitId;
        this.snapshotType = snapshotType;
        this.loadCommitProps = loadCommitProps;
    }

    public QueryParams changeAggregate(boolean newAggregate) {
        return new QueryParams(this.limit, this.skip, this.from, this.to, this.commitIds, this.version, this.author, this.commitProperties, newAggregate, this.newObjectChanges, this.changedProperty, this.toCommitId, this.snapshotType, this.loadCommitProps);
    }

    public QueryParams nextPage() {
        return new QueryParams(this.limit, this.skip + this.limit, this.from, this.to, this.commitIds, this.version, this.author, this.commitProperties, this.aggregate, this.newObjectChanges, this.changedProperty, this.toCommitId, this.snapshotType, this.loadCommitProps);
    }

    public int limit() {
        return this.limit;
    }

    public int skip() {
        return this.skip;
    }

    public Optional<LocalDateTime> from() {
        return Optional.ofNullable(this.from);
    }

    public Optional<LocalDateTime> to() {
        return Optional.ofNullable(this.to);
    }

    public Optional<CommitId> toCommitId() {
        return Optional.ofNullable(this.toCommitId);
    }

    public Set<CommitId> commitIds() {
        return Collections.unmodifiableSet(this.commitIds);
    }

    public Map<String, String> commitProperties() {
        return this.commitProperties != null ? this.commitProperties : Collections.emptyMap();
    }

    public Optional<String> changedProperty() {
        return Optional.ofNullable(this.changedProperty);
    }

    public Optional<Long> version() {
        return Optional.ofNullable(this.version);
    }

    public Optional<String> author() {
        return Optional.ofNullable(this.author);
    }

    public boolean isAggregate() {
        return this.aggregate;
    }

    public boolean isLoadCommitProps() {
        return this.loadCommitProps;
    }

    public Optional<SnapshotType> snapshotType() {
        return Optional.ofNullable(this.snapshotType);
    }

    public boolean newObjectChanges() {
        return this.newObjectChanges;
    }

    public String toString() {
        return ToStringBuilder.toString(this, new Object[]{"aggregate", this.aggregate, "from", this.from, "to", this.to, "toCommitId", this.toCommitId, "commitIds", this.commitIds, "changedProperty", this.changedProperty, "version", this.version, "author", this.author, "newObjectChanges", this.newObjectChanges, "snapshotType", this.snapshotType, "limit", this.limit, "skip", this.skip});
    }

    public boolean hasDates() {
        return this.from().isPresent() || this.to().isPresent();
    }

    public boolean isDateInRange(LocalDateTime date) {
        if (this.from().isPresent() && this.from().get().isAfter(date)) {
            return false;
        }
        return !this.to().isPresent() || !this.to().get().isBefore(date);
    }
}

