/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.lang.reflect.Type;
import java.util.Optional;
import java.util.function.Function;
import org.javers.common.collections.WellKnownValueTypes;
import org.javers.common.reflection.ReflectionUtil;
import org.javers.core.diff.custom.CustomValueComparator;
import org.javers.core.metamodel.type.PrimitiveOrValueType;

public class ValueType
extends PrimitiveOrValueType {
    private final Optional<Function<Object, String>> toStringFunction;

    public ValueType(Type baseJavaType) {
        super(baseJavaType);
        this.toStringFunction = Optional.empty();
    }

    ValueType(Type baseJavaType, CustomValueComparator customValueComparator, Function<Object, String> toStringFunction) {
        super(baseJavaType, customValueComparator);
        this.toStringFunction = Optional.ofNullable(toStringFunction);
    }

    @Override
    public String smartToString(Object cdo) {
        if (cdo == null) {
            return "";
        }
        if (WellKnownValueTypes.isValueType(cdo)) {
            return cdo.toString();
        }
        return this.toStringFunction.map(f -> (String)f.apply(cdo)).orElse(ReflectionUtil.reflectiveToString(cdo));
    }
}

