/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core;

import java.util.Collections;
import java.util.List;
import org.javers.common.string.PrettyValuePrinter;
import org.javers.common.validation.Validate;
import org.javers.core.Changes;
import org.javers.core.ChangesByObject;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.diff.Change;

public final class ChangesByCommit {
    private final List<Change> changes;
    private final CommitMetadata commitMetadata;
    private final transient PrettyValuePrinter valuePrinter;

    ChangesByCommit(CommitMetadata commitMetadata, List<Change> changes, PrettyValuePrinter valuePrinter) {
        Validate.argumentsAreNotNull(commitMetadata, changes, valuePrinter);
        this.changes = new Changes(changes, valuePrinter);
        this.commitMetadata = commitMetadata;
        this.valuePrinter = valuePrinter;
    }

    public final String prettyPrint() {
        return this.toString();
    }

    public List<ChangesByObject> groupByObject() {
        return new Changes(this.changes, this.valuePrinter).groupByObject();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Commit " + this.commitMetadata.getId() + " done by " + this.commitMetadata.getAuthor() + " at " + this.valuePrinter.format(this.commitMetadata.getCommitDate()) + " :\n");
        this.groupByObject().forEach(it -> b.append(it.toString()));
        return b.toString();
    }

    public List<Change> get() {
        return Collections.unmodifiableList(this.changes);
    }

    public CommitMetadata getCommit() {
        return this.commitMetadata;
    }
}

