/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.changetype.map;

import java.util.Objects;
import org.javers.common.string.ToStringBuilder;
import org.javers.core.diff.changetype.Atomic;
import org.javers.core.diff.changetype.map.EntryChange;

public class EntryValueChange
extends EntryChange {
    private final Atomic leftValue;
    private final Atomic rightValue;

    public EntryValueChange(Object key, Object leftValue, Object rightValue) {
        super(key);
        this.leftValue = new Atomic(leftValue);
        this.rightValue = new Atomic(rightValue);
    }

    public Object getLeftValue() {
        return this.leftValue.unwrap();
    }

    public Object getRightValue() {
        return this.rightValue.unwrap();
    }

    public Atomic getWrappedLeftValue() {
        return this.leftValue;
    }

    public Atomic getWrappedRightValue() {
        return this.rightValue;
    }

    public String toString() {
        return ToStringBuilder.format(this.getKey()) + " : " + ToStringBuilder.format(this.getLeftValue()) + " changed to " + ToStringBuilder.format(this.getRightValue());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof EntryValueChange) {
            EntryValueChange that = (EntryValueChange)obj;
            return super.equals(that) && Objects.equals(this.leftValue, that.leftValue) && Objects.equals(this.rightValue, that.rightValue);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.leftValue, this.rightValue);
    }
}

