/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core;

import com.google.gson.TypeAdapter;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.javers.common.collections.Lists;
import org.javers.common.date.DateProvider;
import org.javers.common.date.DefaultDateProvider;
import org.javers.common.reflection.ReflectionUtil;
import org.javers.common.validation.Validate;
import org.javers.core.AbstractContainerBuilder;
import org.javers.core.CommitIdGenerator;
import org.javers.core.ConditionalTypesPlugin;
import org.javers.core.CoreJaversModule;
import org.javers.core.Javers;
import org.javers.core.JaversCore;
import org.javers.core.JaversCoreConfiguration;
import org.javers.core.MappingStyle;
import org.javers.core.commit.CommitFactoryModule;
import org.javers.core.diff.DiffFactoryModule;
import org.javers.core.diff.ListCompareAlgorithm;
import org.javers.core.diff.appenders.DiffAppendersModule;
import org.javers.core.diff.custom.CustomPropertyComparator;
import org.javers.core.diff.custom.CustomToNativeAppenderAdapter;
import org.javers.core.diff.custom.CustomValueComparator;
import org.javers.core.graph.GraphFactoryModule;
import org.javers.core.graph.ObjectAccessHook;
import org.javers.core.graph.TailoredJaversMemberFactoryModule;
import org.javers.core.json.JsonAdvancedTypeAdapter;
import org.javers.core.json.JsonConverter;
import org.javers.core.json.JsonConverterBuilder;
import org.javers.core.json.JsonTypeAdapter;
import org.javers.core.json.typeadapter.change.ChangeTypeAdaptersModule;
import org.javers.core.json.typeadapter.commit.CommitTypeAdaptersModule;
import org.javers.core.metamodel.annotation.TypeName;
import org.javers.core.metamodel.clazz.ClientsClassDefinition;
import org.javers.core.metamodel.clazz.CustomDefinition;
import org.javers.core.metamodel.clazz.EntityDefinition;
import org.javers.core.metamodel.clazz.IgnoredTypeDefinition;
import org.javers.core.metamodel.clazz.ValueDefinition;
import org.javers.core.metamodel.clazz.ValueObjectDefinition;
import org.javers.core.metamodel.scanner.ScannerModule;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.TypeMapper;
import org.javers.core.metamodel.type.TypeMapperModule;
import org.javers.core.metamodel.type.ValueType;
import org.javers.core.pico.AddOnsModule;
import org.javers.core.snapshot.SnapshotModule;
import org.javers.groovysupport.GroovyAddOns;
import org.javers.guava.GuavaAddOns;
import org.javers.jodasupport.JodaAddOns;
import org.javers.mongosupport.MongoLong64JsonDeserializer;
import org.javers.mongosupport.RequiredMongoSupportPredicate;
import org.javers.repository.api.JaversExtendedRepository;
import org.javers.repository.api.JaversRepository;
import org.javers.repository.inmemory.InMemoryRepositoryModule;
import org.javers.shadow.ShadowModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaversBuilder
extends AbstractContainerBuilder {
    private static final Logger logger = LoggerFactory.getLogger(JaversBuilder.class);
    private final Map<Class, ClientsClassDefinition> clientsClassDefinitions = new HashMap<Class, ClientsClassDefinition>();
    private final Map<Class, Function<Object, String>> mappedToStringFunction = new ConcurrentHashMap<Class, Function<Object, String>>();
    private final Set<Class> classesToScan = new HashSet<Class>();
    private final Set<ConditionalTypesPlugin> conditionalTypesPlugins;
    private JaversRepository repository;
    private DateProvider dateProvider;
    private long bootStart = System.currentTimeMillis();

    public static JaversBuilder javers() {
        return new JaversBuilder();
    }

    protected JaversBuilder() {
        logger.debug("starting up JaVers ...");
        this.conditionalTypesPlugins = new HashSet<ConditionalTypesPlugin>();
        if (ReflectionUtil.isClassPresent("groovy.lang.MetaClass")) {
            this.conditionalTypesPlugins.add(new GroovyAddOns());
        }
        if (ReflectionUtil.isClassPresent("org.joda.time.LocalDate")) {
            this.conditionalTypesPlugins.add(new JodaAddOns());
        }
        if (ReflectionUtil.isClassPresent("com.google.common.collect.Multimap")) {
            this.conditionalTypesPlugins.add(new GuavaAddOns());
        }
        this.bootContainer();
        this.addModule(new CoreJaversModule(this.getContainer()));
    }

    public Javers build() {
        Javers javers = this.assembleJaversInstance();
        this.repository.ensureSchema();
        long boot = System.currentTimeMillis() - this.bootStart;
        logger.info("JaVers instance started in {} ms", (Object)boot);
        return javers;
    }

    protected Javers assembleJaversInstance() {
        this.addModule(new DiffFactoryModule());
        this.addModule(new CommitFactoryModule(this.getContainer()));
        this.addModule(new SnapshotModule(this.getContainer()));
        this.addModule(new GraphFactoryModule(this.getContainer()));
        this.addModule(new DiffAppendersModule(this.coreConfiguration(), this.getContainer()));
        this.addModule(new TailoredJaversMemberFactoryModule(this.coreConfiguration(), this.getContainer()));
        this.addModule(new ScannerModule(this.coreConfiguration(), this.getContainer()));
        this.addModule(new ShadowModule(this.getContainer()));
        Set<JaversType> additionalTypes = this.bootAddOns();
        this.bootManagedTypeModule();
        additionalTypes.addAll(this.bootJsonConverter());
        this.bootDateTimeProvider();
        for (Class c : this.classesToScan) {
            this.typeMapper().getJaversType(c);
        }
        this.typeMapper().addTypes(additionalTypes);
        this.bootRepository();
        return this.getContainerComponent(JaversCore.class);
    }

    public JaversBuilder registerJaversRepository(JaversRepository repository) {
        Validate.argumentsAreNotNull(repository);
        this.repository = repository;
        return this;
    }

    public JaversBuilder registerEntity(Class<?> entityClass) {
        Validate.argumentIsNotNull(entityClass);
        return this.registerEntity(new EntityDefinition(entityClass));
    }

    public JaversBuilder registerValueObject(Class<?> valueObjectClass) {
        Validate.argumentIsNotNull(valueObjectClass);
        this.registerType(new ValueObjectDefinition(valueObjectClass));
        return this;
    }

    public JaversBuilder registerEntity(EntityDefinition entityDefinition) {
        Validate.argumentIsNotNull(entityDefinition);
        return this.registerType(entityDefinition);
    }

    public JaversBuilder registerType(ClientsClassDefinition clientsClassDefinition) {
        Validate.argumentIsNotNull(clientsClassDefinition);
        this.clientsClassDefinitions.put(clientsClassDefinition.getBaseJavaClass(), clientsClassDefinition);
        return this;
    }

    public JaversBuilder registerValueObject(ValueObjectDefinition valueObjectDefinition) {
        Validate.argumentIsNotNull(valueObjectDefinition);
        this.registerType(valueObjectDefinition);
        return this;
    }

    public JaversBuilder withPackagesToScan(String packagesToScan) {
        if (packagesToScan == null || packagesToScan.trim().isEmpty()) {
            return this;
        }
        long start = System.currentTimeMillis();
        logger.info("scanning package(s): {}", (Object)packagesToScan);
        List<Class<?>> scan = ReflectionUtil.findClasses(TypeName.class, packagesToScan.replaceAll(" ", "").split(","));
        for (Class<?> c : scan) {
            this.scanTypeName(c);
        }
        long delta = System.currentTimeMillis() - start;
        logger.info("found {} ManagedClasse(s) with @TypeName in {} ms", (Object)scan.size(), (Object)delta);
        return this;
    }

    public JaversBuilder scanTypeName(Class userType) {
        this.classesToScan.add(userType);
        return this;
    }

    public JaversBuilder registerValue(Class<?> valueClass) {
        Validate.argumentIsNotNull(valueClass);
        this.registerType(new ValueDefinition(valueClass));
        return this;
    }

    public <T> JaversBuilder registerValue(Class<T> valueClass, CustomValueComparator<T> customValueComparator) {
        Validate.argumentsAreNotNull(valueClass, customValueComparator);
        if (!this.clientsClassDefinitions.containsKey(valueClass)) {
            this.registerType(new ValueDefinition(valueClass));
        }
        ValueDefinition def = (ValueDefinition)this.getClassDefinition(valueClass);
        def.setCustomValueComparator(customValueComparator);
        return this;
    }

    public <T> JaversBuilder registerValueWithCustomToString(Class<T> valueClass, Function<T, String> toString) {
        Validate.argumentsAreNotNull(valueClass, toString);
        if (!this.clientsClassDefinitions.containsKey(valueClass)) {
            this.registerType(new ValueDefinition(valueClass));
        }
        ValueDefinition def = (ValueDefinition)this.getClassDefinition(valueClass);
        def.setToStringFunction(toString);
        return this;
    }

    public JaversBuilder registerIgnoredClass(Class<?> ignoredClass) {
        Validate.argumentIsNotNull(ignoredClass);
        this.registerType(new IgnoredTypeDefinition(ignoredClass));
        return this;
    }

    public JaversBuilder registerValueTypeAdapter(JsonTypeAdapter typeAdapter) {
        for (Class c : typeAdapter.getValueTypes()) {
            this.registerValue(c);
        }
        this.jsonConverterBuilder().registerJsonTypeAdapter(typeAdapter);
        return this;
    }

    public JaversBuilder registerJsonAdvancedTypeAdapter(JsonAdvancedTypeAdapter adapter) {
        this.jsonConverterBuilder().registerJsonAdvancedTypeAdapter(adapter);
        return this;
    }

    public JaversBuilder registerValueGsonTypeAdapter(Class valueType, TypeAdapter nativeAdapter) {
        this.registerValue(valueType);
        this.jsonConverterBuilder().registerNativeTypeAdapter(valueType, nativeAdapter);
        return this;
    }

    public JaversBuilder withTypeSafeValues(boolean typeSafeValues) {
        this.jsonConverterBuilder().typeSafeValues(typeSafeValues);
        return this;
    }

    public JaversBuilder withPrettyPrint(boolean prettyPrint) {
        this.jsonConverterBuilder().prettyPrint(prettyPrint);
        return this;
    }

    public JaversBuilder registerEntities(Class<?> ... entityClasses) {
        for (Class<?> clazz : entityClasses) {
            this.registerEntity(clazz);
        }
        return this;
    }

    public JaversBuilder registerValueObjects(Class<?> ... valueObjectClasses) {
        for (Class<?> clazz : valueObjectClasses) {
            this.registerValueObject(clazz);
        }
        return this;
    }

    public JaversBuilder withMappingStyle(MappingStyle mappingStyle) {
        Validate.argumentIsNotNull((Object)mappingStyle);
        this.coreConfiguration().withMappingStyle(mappingStyle);
        return this;
    }

    @Deprecated
    public JaversBuilder withCommitIdGenerator(CommitIdGenerator commitIdGenerator) {
        Validate.argumentIsNotNull((Object)commitIdGenerator);
        this.coreConfiguration().withCommitIdGenerator(commitIdGenerator);
        return this;
    }

    public JaversBuilder withNewObjectsSnapshot(boolean newObjectsSnapshot) {
        this.coreConfiguration().withNewObjectsSnapshot(newObjectsSnapshot);
        return this;
    }

    public JaversBuilder withObjectAccessHook(ObjectAccessHook objectAccessHook) {
        this.removeComponent(ObjectAccessHook.class);
        this.bindComponent(ObjectAccessHook.class, objectAccessHook);
        return this;
    }

    public <T> JaversBuilder registerCustomComparator(CustomPropertyComparator<T, ?> comparator, Class<T> customType) {
        this.registerType(new CustomDefinition(customType));
        this.bindComponent(comparator, new CustomToNativeAppenderAdapter(comparator, customType));
        return this;
    }

    public JaversBuilder withListCompareAlgorithm(ListCompareAlgorithm algorithm) {
        Validate.argumentIsNotNull((Object)algorithm);
        this.coreConfiguration().withListCompareAlgorithm(algorithm);
        return this;
    }

    public JaversBuilder withDateTimeProvider(DateProvider dateProvider) {
        Validate.argumentIsNotNull(dateProvider);
        this.dateProvider = dateProvider;
        return this;
    }

    private void mapRegisteredClasses() {
        TypeMapper typeMapper = this.typeMapper();
        for (ClientsClassDefinition def : this.clientsClassDefinitions.values()) {
            typeMapper.registerClientsClass(def);
        }
    }

    private TypeMapper typeMapper() {
        return this.getContainerComponent(TypeMapper.class);
    }

    private JaversCoreConfiguration coreConfiguration() {
        return this.getContainerComponent(JaversCoreConfiguration.class);
    }

    private JsonConverterBuilder jsonConverterBuilder() {
        return this.getContainerComponent(JsonConverterBuilder.class);
    }

    private Set<JaversType> bootAddOns() {
        HashSet<JaversType> additionalTypes = new HashSet<JaversType>();
        for (ConditionalTypesPlugin plugin : this.conditionalTypesPlugins) {
            logger.info("loading " + plugin.getClass().getSimpleName() + " ...");
            plugin.beforeAssemble(this);
            additionalTypes.addAll(plugin.getNewTypes());
            AddOnsModule addOnsModule = new AddOnsModule(this.getContainer(), plugin.getPropertyChangeAppenders());
            this.addModule(addOnsModule);
        }
        return additionalTypes;
    }

    private void bootManagedTypeModule() {
        this.addModule(new TypeMapperModule(this.getContainer()));
        this.mapRegisteredClasses();
    }

    private Collection<JaversType> bootJsonConverter() {
        JsonConverterBuilder jsonConverterBuilder = this.jsonConverterBuilder();
        this.addModule(new ChangeTypeAdaptersModule(this.getContainer()));
        this.addModule(new CommitTypeAdaptersModule(this.getContainer()));
        if (new RequiredMongoSupportPredicate().test(this.repository)) {
            jsonConverterBuilder.registerNativeGsonDeserializer((Type)((Object)Long.class), new MongoLong64JsonDeserializer());
        }
        jsonConverterBuilder.registerJsonTypeAdapters(this.getComponents(JsonTypeAdapter.class));
        JsonConverter jsonConverter = jsonConverterBuilder.build();
        this.addComponent(jsonConverter);
        return Lists.transform(jsonConverterBuilder.getValueTypes(), c -> new ValueType((Type)c));
    }

    private void bootDateTimeProvider() {
        if (this.dateProvider == null) {
            this.dateProvider = new DefaultDateProvider();
        }
        this.addComponent(this.dateProvider);
    }

    private void bootRepository() {
        if (this.repository == null) {
            logger.info("using fake InMemoryRepository, registerType actual implementation via JaversBuilder.registerJaversRepository()");
            this.addModule(new InMemoryRepositoryModule(this.getContainer()));
            this.repository = this.getContainerComponent(JaversRepository.class);
        } else {
            this.repository.setJsonConverter(this.getContainerComponent(JsonConverter.class));
            this.addComponent(this.repository);
        }
        this.addComponent(JaversExtendedRepository.class);
    }

    private <T extends ClientsClassDefinition> T getClassDefinition(Class<?> baseJavaClass) {
        return (T)this.clientsClassDefinitions.get(baseJavaClass);
    }
}

