/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.jql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.javers.common.collections.Consumer;
import org.javers.common.validation.Validate;
import org.javers.core.commit.CommitId;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.InstanceId;
import org.javers.core.metamodel.object.ValueObjectId;
import org.javers.repository.api.JaversExtendedRepository;
import org.javers.repository.api.QueryParams;
import org.javers.repository.api.QueryParamsBuilder;
import org.javers.repository.jql.JqlQuery;
import org.javers.shadow.Shadow;
import org.javers.shadow.ShadowFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShadowQueryRunner {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.javers.JQL");
    private final JaversExtendedRepository repository;
    private final ShadowFactory shadowFactory;

    public ShadowQueryRunner(JaversExtendedRepository repository, ShadowFactory shadowFactory) {
        this.repository = repository;
        this.shadowFactory = shadowFactory;
    }

    public List<Shadow> queryForShadows(JqlQuery query, List<CdoSnapshot> coreSnapshots) {
        CommitTable commitTable = new CommitTable(coreSnapshots, query.getMaxGapsToFill(), query);
        if (query.getShadowScope().isCommitDeep()) {
            commitTable.loadFullCommits();
        }
        List<Shadow> shadows = commitTable.rootsForQuery(query).stream().map(r -> this.shadowFactory.createShadow(r.root, r.context, (cm, targetId) -> commitTable.findLatestTo(cm.getId(), (GlobalId)targetId))).collect(Collectors.toList());
        return shadows;
    }

    static final class ReferenceKey {
        private final CommitId rootContext;
        private final GlobalId targetId;

        ReferenceKey(CommitId rootContext, GlobalId targetId) {
            Validate.argumentsAreNotNull(rootContext, targetId);
            this.rootContext = rootContext;
            this.targetId = targetId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReferenceKey that = (ReferenceKey)o;
            return Objects.equals(this.rootContext, that.rootContext) && Objects.equals(this.targetId, that.targetId);
        }

        public int hashCode() {
            return Objects.hash(this.rootContext, this.targetId);
        }
    }

    private static class CommitEntry {
        private final CommitMetadata commitMetadata;
        private final Map<GlobalId, CdoSnapshot> entities = new HashMap<GlobalId, CdoSnapshot>();
        private final Map<ValueObjectId, CdoSnapshot> valueObjects = new HashMap<ValueObjectId, CdoSnapshot>();

        CommitEntry(CommitMetadata commitMetadata) {
            this.commitMetadata = commitMetadata;
        }

        void append(CdoSnapshot snapshot) {
            if (snapshot.getGlobalId() instanceof InstanceId) {
                this.entities.put(snapshot.getGlobalId(), snapshot);
            }
            if (snapshot.getGlobalId() instanceof ValueObjectId) {
                this.valueObjects.put((ValueObjectId)snapshot.getGlobalId(), snapshot);
            }
        }

        CdoSnapshot getAny(GlobalId globalId) {
            if (this.entities.containsKey(globalId)) {
                return this.entities.get(globalId);
            }
            return this.valueObjects.get(globalId);
        }

        Collection<CdoSnapshot> getEntities() {
            return this.entities.values();
        }

        Stream<CdoSnapshot> getAllStream() {
            return Stream.concat(this.valueObjects.values().stream(), this.entities.values().stream());
        }

        Set<GlobalId> getMissingParents() {
            Set<GlobalId> result = this.valueObjects.keySet().stream().map(voId -> voId.getOwnerId()).filter(instanceId -> !this.entities.containsKey(instanceId)).collect(Collectors.toSet());
            result.addAll(this.valueObjects.keySet().stream().flatMap(voId -> voId.getParentValueObjectIds().stream()).filter(voId -> !this.valueObjects.containsKey(voId)).collect(Collectors.toSet()));
            return result;
        }
    }

    class CommitTable {
        private final int maxGapsToFill;
        private int filledGaps;
        private final Map<CommitId, CommitEntry> commitsMap = new TreeMap<CommitId, CommitEntry>();
        private final JqlQuery query;

        CommitTable(List<CdoSnapshot> coreSnapshots, int maxGapsToFill, JqlQuery query) {
            this.maxGapsToFill = maxGapsToFill;
            this.query = query;
            this.appendSnapshots(coreSnapshots);
        }

        List<ShadowRoot> rootsForQuery(JqlQuery query) {
            this.fillMissingParents();
            ArrayList orderedCommits = new ArrayList();
            this.commitsMap.values().forEach(it -> orderedCommits.add(0, it));
            return orderedCommits.stream().flatMap(e -> e.getAllStream().filter(s -> query.matches(s.getGlobalId())).map(s -> new ShadowRoot(((CommitEntry)e).commitMetadata, (CdoSnapshot)s))).collect(Collectors.toList());
        }

        void loadFullCommits() {
            if (this.commitsMap.isEmpty()) {
                return;
            }
            QueryParams params = QueryParamsBuilder.withLimit(Integer.MAX_VALUE).commitIds(this.commitsMap.keySet().stream().collect(Collectors.toSet())).build();
            List<CdoSnapshot> fullCommitsSnapshots = ShadowQueryRunner.this.repository.getSnapshots(params);
            this.query.stats().logQueryInCommitDeepScope(fullCommitsSnapshots);
            this.appendSnapshots(fullCommitsSnapshots);
        }

        CdoSnapshot findLatestTo(CommitId rootContext, GlobalId targetId) {
            if (!this.commitsMap.containsKey(rootContext)) {
                return null;
            }
            CdoSnapshot latest = this.findLatestToInCommitTable(rootContext, targetId);
            if (latest == null) {
                this.appendSnapshots(this.fillGapFromRepository(new ReferenceKey(rootContext, targetId), 15));
            }
            if ((latest = this.findLatestToInCommitTable(rootContext, targetId)) == null) {
                this.query.stats().logMaxGapsToFillExceededInfo(targetId);
            }
            return latest;
        }

        private CdoSnapshot findLatestToInCommitTable(CommitId rootContext, GlobalId targetId) {
            ArrayList found = new ArrayList();
            this.iterateUntil(ce -> {
                if (ce.getAny(targetId) != null) {
                    found.add(ce.getAny(targetId));
                }
            }, rootContext);
            if (found.size() == 0) {
                return null;
            }
            return (CdoSnapshot)found.get(found.size() - 1);
        }

        private boolean isInChildValueObjectScope(ReferenceKey referenceKey) {
            return this.query.isAggregate() && referenceKey.targetId instanceof ValueObjectId;
        }

        List<CdoSnapshot> fillGapFromRepository(ReferenceKey referenceKey, int limit) {
            List<CdoSnapshot> historicals;
            if (this.filledGaps >= this.maxGapsToFill && !this.isInChildValueObjectScope(referenceKey)) {
                return Collections.emptyList();
            }
            if (this.isInChildValueObjectScope(referenceKey)) {
                historicals = ShadowQueryRunner.this.repository.getHistoricals(referenceKey.targetId, referenceKey.rootContext, false, limit);
                this.query.stats().logQueryInChildValueObjectScope(referenceKey.targetId, referenceKey.rootContext, historicals.size());
            } else {
                historicals = ShadowQueryRunner.this.repository.getHistoricals(referenceKey.targetId, referenceKey.rootContext, this.query.isAggregate(), limit);
                this.query.stats().logQueryInDeepPlusScope(referenceKey.targetId, referenceKey.rootContext, historicals.size());
            }
            ++this.filledGaps;
            return historicals;
        }

        void fillMissingParents() {
            HashMap movingLatest = new HashMap();
            this.commitsMap.values().forEach(commitEntry -> {
                commitEntry.getMissingParents().stream().filter(movingLatest::containsKey).forEach(voId -> commitEntry.append((CdoSnapshot)movingLatest.get(voId)));
                commitEntry.getAllStream().forEach(e -> movingLatest.put(e.getGlobalId(), e));
            });
        }

        void appendSnapshots(List<CdoSnapshot> snapshots) {
            snapshots.forEach(it -> this.appendSnapshot((CdoSnapshot)it));
        }

        CommitEntry appendSnapshot(CdoSnapshot snapshot) {
            CommitEntry entry = this.commitsMap.get(snapshot.getCommitMetadata().getId());
            if (entry == null) {
                entry = new CommitEntry(snapshot.getCommitMetadata());
                this.commitsMap.put(snapshot.getCommitId(), entry);
            }
            entry.append(snapshot);
            return entry;
        }

        void iterateUntil(Consumer<CommitEntry> consumer, CommitId bound) {
            for (CommitEntry ce : this.commitsMap.values()) {
                consumer.consume(ce);
                if (!ce.commitMetadata.getId().equals(bound)) continue;
                break;
            }
        }
    }

    private static class ShadowRoot {
        final CommitMetadata context;
        final CdoSnapshot root;

        ShadowRoot(CdoSnapshot root) {
            this.context = root.getCommitMetadata();
            this.root = root;
        }

        ShadowRoot(CommitMetadata context, CdoSnapshot root) {
            this.context = context;
            this.root = root;
        }
    }
}

