/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.jql;

import java.util.Set;
import org.javers.common.collections.Sets;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.string.ToStringBuilder;
import org.javers.core.metamodel.object.GlobalIdFactory;
import org.javers.core.metamodel.type.EntityType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.TypeMapper;
import org.javers.repository.jql.AnyDomainObjectFilter;
import org.javers.repository.jql.ClassFilter;
import org.javers.repository.jql.Filter;
import org.javers.repository.jql.GlobalIdDTO;
import org.javers.repository.jql.IdFilter;
import org.javers.repository.jql.VoOwnerFilter;

abstract class FilterDefinition {
    FilterDefinition() {
    }

    abstract Filter compile(GlobalIdFactory var1, TypeMapper var2);

    static class AnyDomainObjectFilterDefinition
    extends FilterDefinition {
        AnyDomainObjectFilterDefinition() {
        }

        @Override
        Filter compile(GlobalIdFactory globalIdFactory, TypeMapper typeMapper) {
            return new AnyDomainObjectFilter();
        }
    }

    static class VoOwnerFilterDefinition
    extends FilterDefinition {
        private final Class ownerEntityClass;
        private final String path;

        VoOwnerFilterDefinition(Class ownerEntityClass, String path) {
            this.ownerEntityClass = ownerEntityClass;
            this.path = path;
        }

        @Override
        Filter compile(GlobalIdFactory globalIdFactory, TypeMapper typeMapper) {
            ManagedType mType = typeMapper.getJaversManagedType(this.ownerEntityClass);
            if (!(mType instanceof EntityType)) {
                throw new JaversException(JaversExceptionCode.MALFORMED_JQL, "queryForChanges: ownerEntityClass {'" + this.ownerEntityClass.getName() + "'} should be an Entity");
            }
            return new VoOwnerFilter((EntityType)mType, this.path);
        }
    }

    static class InstanceFilterDefinition
    extends FilterDefinition {
        private final Object instance;

        InstanceFilterDefinition(Object instance) {
            this.instance = instance;
        }

        @Override
        Filter compile(GlobalIdFactory globalIdFactory, TypeMapper typeMapper) {
            try {
                return new IdFilter(globalIdFactory.createId(this.instance));
            }
            catch (JaversException e) {
                if (e.getCode() == JaversExceptionCode.MANAGED_CLASS_MAPPING_ERROR) {
                    throw new JaversException(JaversExceptionCode.MALFORMED_JQL, "object passed to byInstance(Object) query should be instance of Entity or ValueObject, got " + typeMapper.getJaversType(this.instance.getClass()) + " - " + ToStringBuilder.format(this.instance) + ".\nDid you mean byInstanceId(Object localId, Class entityClass)?");
                }
                throw e;
            }
        }
    }

    static class ClassFilterDefinition
    extends FilterDefinition {
        private final Set<Class> requiredClasses;

        ClassFilterDefinition(Set<Class> requiredClasses) {
            this.requiredClasses = requiredClasses;
        }

        @Override
        Filter compile(GlobalIdFactory globalIdFactory, TypeMapper typeMapper) {
            return new ClassFilter(Sets.transform(this.requiredClasses, javaClass -> typeMapper.getJaversManagedType((Class)javaClass)));
        }
    }

    static class IdFilterDefinition
    extends FilterDefinition {
        private final GlobalIdDTO globalIdDTO;

        IdFilterDefinition(GlobalIdDTO globalIdDTO) {
            this.globalIdDTO = globalIdDTO;
        }

        @Override
        Filter compile(GlobalIdFactory globalIdFactory, TypeMapper typeMapper) {
            return new IdFilter(globalIdFactory.createFromDto(this.globalIdDTO));
        }
    }
}

