/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.clazz;

import java.util.Optional;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.clazz.ClientsClassDefinitionBuilder;
import org.javers.core.metamodel.clazz.EntityDefinition;

public class EntityDefinitionBuilder
extends ClientsClassDefinitionBuilder<EntityDefinitionBuilder> {
    private Optional<String> idPropertyName = Optional.empty();
    private boolean shallowReference;

    EntityDefinitionBuilder(Class<?> entity) {
        super(entity);
    }

    public static EntityDefinitionBuilder entityDefinition(Class<?> entity) {
        return new EntityDefinitionBuilder(entity);
    }

    public EntityDefinitionBuilder withIdPropertyName(String idPropertyName) {
        Validate.argumentIsNotNull(idPropertyName);
        this.idPropertyName = Optional.of(idPropertyName);
        return this;
    }

    public EntityDefinitionBuilder withShallowReference() {
        this.shallowReference = true;
        return this;
    }

    @Override
    public EntityDefinition build() {
        return new EntityDefinition(this);
    }

    public Optional<String> getIdPropertyName() {
        return this.idPropertyName;
    }

    public boolean isShallowReference() {
        return this.shallowReference;
    }
}

