/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.javers.common.collections.Collections;
import org.javers.common.collections.EnumerableFunction;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.object.EnumerationAwareOwnerContext;
import org.javers.core.metamodel.object.OwnerContext;
import org.javers.core.metamodel.type.ContainerType;

public class CollectionType
extends ContainerType {
    public CollectionType(Type baseJavaType) {
        super(baseJavaType);
    }

    @Override
    public boolean isEmpty(Object collection) {
        return collection == null || ((Collection)collection).isEmpty();
    }

    @Override
    public Object map(Object sourceEnumerable, EnumerableFunction mapFunction, OwnerContext owner) {
        Validate.argumentsAreNotNull(mapFunction, owner);
        Collection sourceCol = Collections.wrapNull(sourceEnumerable);
        HashSet targetSet = new HashSet(sourceCol.size());
        EnumerationAwareOwnerContext enumerationContext = new EnumerationAwareOwnerContext(owner, true);
        for (Object sourceVal : sourceCol) {
            targetSet.add(mapFunction.apply(sourceVal, enumerationContext));
        }
        return java.util.Collections.unmodifiableSet(targetSet);
    }

    @Override
    public Object map(Object sourceEnumerable, Function mapFunction) {
        Collection sourceCol = Collections.wrapNull(sourceEnumerable);
        return sourceCol.stream().map(mapFunction).filter(it -> it != null).collect(Collectors.toSet());
    }
}

