/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.jql;

import java.util.List;
import java.util.Optional;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.validation.Validate;
import org.javers.core.diff.Change;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.GlobalIdFactory;
import org.javers.core.metamodel.type.TypeMapper;
import org.javers.repository.api.JaversExtendedRepository;
import org.javers.repository.jql.GlobalIdDTO;
import org.javers.repository.jql.JqlQuery;
import org.javers.repository.jql.QueryType;
import org.javers.repository.jql.ShadowQueryRunner;
import org.javers.repository.jql.VoOwnerFilter;
import org.javers.shadow.Shadow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryRunner {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.javers.JQL");
    private final JaversExtendedRepository repository;
    private final GlobalIdFactory globalIdFactory;
    private final TypeMapper typeMapper;
    private final ShadowQueryRunner shadowQueryRunner;

    public QueryRunner(JaversExtendedRepository repository, GlobalIdFactory globalIdFactory, TypeMapper typeMapper, ShadowQueryRunner shadowQueryRunner) {
        this.repository = repository;
        this.globalIdFactory = globalIdFactory;
        this.typeMapper = typeMapper;
        this.shadowQueryRunner = shadowQueryRunner;
    }

    public List<Shadow> queryForShadows(JqlQuery query) {
        query.compile(this.globalIdFactory, this.typeMapper, QueryType.SHADOWS);
        List<CdoSnapshot> snapshots = this.queryForSnapshots(query);
        query.stats().logShallowQuery(snapshots);
        List<Shadow> result = this.shadowQueryRunner.queryForShadows(query, snapshots);
        query.stats().stop();
        logger.debug("queryForShadows executed: {}", (Object)query);
        return result;
    }

    public Optional<CdoSnapshot> runQueryForLatestSnapshot(GlobalIdDTO globalId) {
        Validate.argumentIsNotNull(globalId);
        return this.repository.getLatest(this.globalIdFactory.createFromDto(globalId));
    }

    public List<CdoSnapshot> queryForSnapshots(JqlQuery query) {
        List<CdoSnapshot> result;
        query.compile(this.globalIdFactory, this.typeMapper, QueryType.SNAPSHOTS);
        if (query.isAnyDomainObjectQuery()) {
            result = this.repository.getSnapshots(query.getQueryParams());
        } else if (query.isIdQuery()) {
            result = this.repository.getStateHistory(query.getIdFilter(), query.getQueryParams());
        } else if (query.isClassQuery()) {
            result = this.repository.getStateHistory(query.getClassFilter(), query.getQueryParams());
        } else if (query.isVoOwnerQuery()) {
            VoOwnerFilter filter = query.getVoOwnerFilter();
            this.globalIdFactory.touchValueObjectFromPath(filter.getOwnerEntity(), filter.getPath());
            result = this.repository.getValueObjectStateHistory(filter.getOwnerEntity(), filter.getPath(), query.getQueryParams());
        } else {
            throw new JaversException(JaversExceptionCode.MALFORMED_JQL, "queryForSnapshots: " + query + " is not supported");
        }
        return result;
    }

    public List<Change> queryForChanges(JqlQuery query) {
        query.compile(this.globalIdFactory, this.typeMapper, QueryType.CHANGES);
        if (query.isAnyDomainObjectQuery()) {
            return this.repository.getChanges(query.isNewObjectChanges(), query.getQueryParams());
        }
        if (query.isIdQuery()) {
            return this.repository.getChangeHistory(query.getIdFilter(), query.getQueryParams());
        }
        if (query.isClassQuery()) {
            return this.repository.getChangeHistory(query.getClassFilter(), query.getQueryParams());
        }
        if (query.isVoOwnerQuery()) {
            VoOwnerFilter filter = query.getVoOwnerFilter();
            this.globalIdFactory.touchValueObjectFromPath(filter.getOwnerEntity(), filter.getPath());
            return this.repository.getValueObjectChangeHistory(filter.getOwnerEntity(), filter.getPath(), query.getQueryParams());
        }
        throw new JaversException(JaversExceptionCode.MALFORMED_JQL, "queryForChanges: " + query + " is not supported");
    }

    private GlobalId fromInstance(Object instance) {
        return this.globalIdFactory.createInstanceId(instance);
    }
}

