/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.object;

import org.javers.common.reflection.ReflectionUtil;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.type.EntityType;

public class InstanceId
extends GlobalId {
    private final Object cdoId;

    InstanceId(String typeName, Object cdoId) {
        super(typeName);
        Validate.argumentsAreNotNull(cdoId);
        this.cdoId = cdoId;
    }

    public static InstanceId createFromInstance(Object instance, EntityType entity) {
        return new InstanceId(entity.getName(), entity.getIdOf(instance));
    }

    public Object getCdoId() {
        return this.cdoId;
    }

    @Override
    public String value() {
        return this.getTypeName() + "/" + this.getCdoIdAsString();
    }

    private String getCdoIdAsString() {
        return ReflectionUtil.reflectiveToString(this.cdoId);
    }

    @Override
    public String toString() {
        return this.getTypeNameShort() + "/" + this.getCdoIdAsString();
    }
}

