/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.api;

import java.util.Objects;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.GlobalId;

public final class SnapshotIdentifier {
    private final GlobalId globalId;
    private final long version;

    public SnapshotIdentifier(GlobalId globalId, long version) {
        Validate.argumentIsNotNull(globalId);
        Validate.argumentCheck(version > 0L, "Version is not a positive number.");
        this.globalId = globalId;
        this.version = version;
    }

    public static SnapshotIdentifier from(CdoSnapshot snapshot) {
        Validate.argumentIsNotNull(snapshot);
        return new SnapshotIdentifier(snapshot.getGlobalId(), snapshot.getVersion());
    }

    public GlobalId getGlobalId() {
        return this.globalId;
    }

    public long getVersion() {
        return this.version;
    }

    public SnapshotIdentifier previous() {
        return new SnapshotIdentifier(this.getGlobalId(), this.getVersion() - 1L);
    }

    public SnapshotIdentifier next() {
        return new SnapshotIdentifier(this.getGlobalId(), this.getVersion() + 1L);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotIdentifier that = (SnapshotIdentifier)o;
        return this.version == that.version && Objects.equals(this.globalId, that.globalId);
    }

    public int hashCode() {
        return Objects.hash(this.globalId, this.version);
    }

    public String toString() {
        return "SnapshotIdentifier{id:" + this.globalId.value() + ", ver:" + this.version + "}";
    }
}

