/*
 * Decompiled with CFR 0.152.
 */
package org.javers.common.string;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.javers.common.validation.Validate;

public class ToStringBuilder {
    public static String typeName(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            parameterizedType.getActualTypeArguments();
            StringBuilder out = new StringBuilder();
            out.append(ToStringBuilder.typeName(parameterizedType.getRawType()) + "<");
            Type[] args = ((ParameterizedType)type).getActualTypeArguments();
            out.append(ToStringBuilder.typeName(args[0]));
            for (int i = 1; i < args.length; ++i) {
                out.append(", " + ToStringBuilder.typeName(args[0]));
            }
            out.append(">");
            return out.toString();
        }
        if (type instanceof Class) {
            return ((Class)type).getSimpleName();
        }
        return type.toString();
    }

    public static String setToString(Set set) {
        return ToStringBuilder.listToString(new ArrayList(set));
    }

    public static String listToString(List list) {
        return "[" + ToStringBuilder.join(list) + "]";
    }

    public static String join(Collection list) {
        if (list == null || list.size() == 0) {
            return "";
        }
        StringBuilder out = new StringBuilder();
        boolean first = true;
        for (Object it : list) {
            if (!first) {
                out.append(",");
            }
            out.append(ToStringBuilder.format(it));
            first = false;
        }
        return out.toString();
    }

    public static String toStringSimple(Object ... fieldsMap) {
        Validate.argumentCheck(fieldsMap.length % 2 == 0, "map expected");
        StringBuilder out = new StringBuilder();
        boolean first = true;
        for (int i = 0; i < fieldsMap.length; i += 2) {
            Object name = fieldsMap[i];
            Object value = fieldsMap[i + 1];
            if (ToStringBuilder.isNullOrEmpty(value)) continue;
            if (first) {
                out.append(ToStringBuilder.addFirstField(name + "", value));
            } else {
                out.append(ToStringBuilder.addField(name + "", value));
            }
            first = false;
        }
        return out.toString();
    }

    private static String format(Object value) {
        if (value instanceof String) {
            return "'" + value + "'";
        }
        if (value instanceof Set) {
            return ToStringBuilder.setToString((Set)value);
        }
        if (value instanceof List) {
            return ToStringBuilder.listToString((List)value);
        }
        if (value instanceof Optional) {
            if (((Optional)value).isPresent()) {
                return ToStringBuilder.format(((Optional)value).get());
            }
            return "empty";
        }
        return value + "";
    }

    private static boolean isNullOrEmpty(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof Boolean) {
            return (Boolean)value == false;
        }
        if (value instanceof Integer) {
            return (Integer)value == 0;
        }
        if (value instanceof Optional) {
            return !((Optional)value).isPresent();
        }
        if (value instanceof String) {
            return ((String)value).isEmpty();
        }
        if (value instanceof Collection) {
            return ((Collection)value).isEmpty();
        }
        if (value instanceof Map) {
            return ((Map)value).isEmpty();
        }
        return false;
    }

    public static String toString(Object instance, Object ... fieldsMap) {
        Validate.argumentIsNotNull(instance);
        return instance.getClass().getSimpleName() + "{" + ToStringBuilder.toStringSimple(fieldsMap) + "}";
    }

    public static String addField(String fieldName, Object value) {
        return ", " + ToStringBuilder.addFirstField(fieldName, value);
    }

    public static String addFirstField(String fieldName, Object value) {
        return fieldName + ":" + ToStringBuilder.format(value);
    }

    public static String addEnumField(String fieldName, Object value) {
        return ", " + fieldName + ":[" + (value != null ? value.toString() : "null") + "]";
    }
}

