/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.reflection.ReflectionUtil;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.clazz.ClientsClassDefinition;
import org.javers.core.metamodel.type.DistancePair;
import org.javers.core.metamodel.type.DuckType;
import org.javers.core.metamodel.type.EntityType;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.TypeFactory;
import org.javers.core.metamodel.type.ValueType;

class TypeMapperState {
    private final Map<String, JaversType> mappedTypes = new ConcurrentHashMap<String, JaversType>();
    private final Map<DuckType, Class> mappedTypeNames = new ConcurrentHashMap<DuckType, Class>();
    private final TypeFactory typeFactory;
    private final ValueType OBJECT_TYPE = new ValueType((Type)((Object)Object.class));

    TypeMapperState(TypeFactory typeFactory) {
        this.typeFactory = typeFactory;
    }

    Class getClassByTypeName(String typeName) {
        return this.getClassByDuckType(new DuckType(typeName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Class getClassByDuckType(DuckType duckType) {
        Validate.argumentsAreNotNull(duckType);
        Class javaType = this.mappedTypeNames.get(duckType);
        if (javaType != null) {
            return javaType;
        }
        String string = duckType.getTypeName();
        synchronized (string) {
            Optional<? extends Class> classForName = this.parseClass(duckType.getTypeName());
            if (classForName.isPresent()) {
                this.mappedTypeNames.put(duckType, classForName.get());
                return classForName.get();
            }
        }
        if (!duckType.isBare()) {
            return this.getClassByDuckType(duckType.bareCopy());
        }
        throw new JaversException(JaversExceptionCode.TYPE_NAME_NOT_FOUND, duckType.getTypeName());
    }

    boolean contains(Type javaType) {
        return this.mappedTypes.containsKey(javaType.toString());
    }

    JaversType getJaversType(Type javaType) {
        Validate.argumentIsNotNull(javaType);
        if (javaType == Object.class) {
            return this.OBJECT_TYPE;
        }
        JaversType jType = this.getFromMap(javaType);
        if (jType != null) {
            return jType;
        }
        return this.computeIfAbsent(javaType, type -> this.infer((Type)type));
    }

    void putIfAbsent(Type javaType, JaversType jType) {
        this.computeIfAbsent(javaType, ignored -> jType);
    }

    void register(ClientsClassDefinition def) {
        Class<?> javaType = def.getBaseJavaClass();
        JaversType newType = this.typeFactory.create(def);
        this.addFullMapping(javaType, newType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JaversType computeIfAbsent(Type javaType, Function<Type, JaversType> computeFunction) {
        Type type = javaType;
        synchronized (type) {
            JaversType mappedType = this.getFromMap(javaType);
            if (mappedType != null) {
                return mappedType;
            }
            JaversType newType = computeFunction.apply(javaType);
            this.addFullMapping(javaType, newType);
            return newType;
        }
    }

    private void addFullMapping(Type javaType, JaversType newType) {
        Validate.argumentsAreNotNull(javaType, newType);
        this.putToMap(javaType, newType);
        if (newType instanceof ManagedType) {
            ManagedType managedType = (ManagedType)newType;
            this.mappedTypeNames.put(new DuckType(managedType.getName()), ReflectionUtil.extractClass(javaType));
            this.mappedTypeNames.put(new DuckType(managedType), ReflectionUtil.extractClass(javaType));
        }
        if (newType instanceof EntityType) {
            this.inferIdPropertyTypeForEntity((EntityType)newType);
        }
    }

    private void inferIdPropertyTypeForEntity(EntityType entityType) {
        Type idType = entityType.getIdPropertyGenericType();
        this.addFullMapping(idType, this.typeFactory.inferIdPropertyTypeAsValue(idType));
    }

    private JaversType infer(Type javaType) {
        Validate.argumentIsNotNull(javaType);
        JaversType prototype = this.findNearestAncestor(javaType);
        JaversType newType = this.typeFactory.infer(javaType, Optional.ofNullable(prototype));
        return newType;
    }

    private JaversType findNearestAncestor(Type javaType) {
        Class javaClass = ReflectionUtil.extractClass(javaType);
        ArrayList<DistancePair> distances = new ArrayList<DistancePair>();
        for (JaversType javersType : this.mappedTypes.values()) {
            DistancePair distancePair = new DistancePair(javaClass, javersType);
            if (javaClass.isArray()) {
                return this.getJaversType((Type)((Object)Object[].class));
            }
            if (distancePair.getDistance() == 0) {
                return distancePair.getJaversType();
            }
            distances.add(distancePair);
        }
        Collections.sort(distances);
        if (((DistancePair)distances.get(0)).isMax()) {
            return null;
        }
        return ((DistancePair)distances.get(0)).getJaversType();
    }

    private Optional<? extends Class> parseClass(String qualifiedName) {
        try {
            return Optional.of(Class.forName(qualifiedName));
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }

    private JaversType getFromMap(Type javaType) {
        return this.mappedTypes.get(javaType.toString());
    }

    private void putToMap(Type javaType, JaversType javersType) {
        this.mappedTypes.put(javaType.toString(), javersType);
    }
}

