/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.jql;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collection;
import java.util.stream.Collectors;
import org.javers.common.collections.Sets;
import org.javers.common.validation.Validate;
import org.javers.core.commit.CommitId;
import org.javers.repository.api.QueryParamsBuilder;
import org.javers.repository.jql.FilterDefinition;
import org.javers.repository.jql.GlobalIdDTO;
import org.javers.repository.jql.InstanceIdDTO;
import org.javers.repository.jql.JqlQuery;
import org.javers.repository.jql.ShadowScope;
import org.javers.repository.jql.ValueObjectIdDTO;

public class QueryBuilder {
    private static final int DEFAULT_LIMIT = 100;
    private static final int DEFAULT_SKIP = 0;
    private final FilterDefinition filter;
    private final QueryParamsBuilder queryParamsBuilder;
    private ShadowScope shadowScope = ShadowScope.SHALLOW;

    private QueryBuilder(FilterDefinition filter) {
        Validate.argumentIsNotNull(filter);
        this.filter = filter;
        this.queryParamsBuilder = QueryParamsBuilder.withLimit(100).skip(0);
    }

    public static QueryBuilder anyDomainObject() {
        return new QueryBuilder(new FilterDefinition.AnyDomainObjectFilterDefinition());
    }

    public static QueryBuilder byClass(Class ... requiredClasses) {
        return new QueryBuilder(new FilterDefinition.ClassFilterDefinition(Sets.asSet(requiredClasses)));
    }

    public static QueryBuilder byInstanceId(Object localId, Class entityClass) {
        Validate.argumentsAreNotNull(localId, entityClass);
        return new QueryBuilder(new FilterDefinition.IdFilterDefinition(InstanceIdDTO.instanceId(localId, entityClass)));
    }

    public static QueryBuilder byInstance(Object instance) {
        Validate.argumentsAreNotNull(instance);
        return new QueryBuilder(new FilterDefinition.InstanceFilterDefinition(instance));
    }

    public static QueryBuilder byValueObject(Class ownerEntityClass, String path) {
        Validate.argumentsAreNotNull(ownerEntityClass, path);
        return new QueryBuilder(new FilterDefinition.VoOwnerFilterDefinition(ownerEntityClass, path));
    }

    public static QueryBuilder byValueObjectId(Object ownerLocalId, Class ownerEntityClass, String path) {
        Validate.argumentsAreNotNull(ownerEntityClass, ownerLocalId, path);
        return new QueryBuilder(new FilterDefinition.IdFilterDefinition(ValueObjectIdDTO.valueObjectId(ownerLocalId, ownerEntityClass, path)));
    }

    public static QueryBuilder byGlobalId(GlobalIdDTO globalId) {
        Validate.argumentIsNotNull(globalId);
        return new QueryBuilder(new FilterDefinition.IdFilterDefinition(globalId));
    }

    public QueryBuilder andProperty(String propertyName) {
        Validate.argumentIsNotNull(propertyName);
        this.queryParamsBuilder.changedProperty(propertyName);
        return this;
    }

    public QueryBuilder withNewObjectChanges(boolean newObjectChanges) {
        this.queryParamsBuilder.newObjectChanges(newObjectChanges);
        return this;
    }

    public QueryBuilder withNewObjectChanges() {
        this.queryParamsBuilder.newObjectChanges(true);
        return this;
    }

    public QueryBuilder withChildValueObjects(boolean aggregate) {
        this.queryParamsBuilder.withChildValueObjects(aggregate);
        return this;
    }

    public QueryBuilder withChildValueObjects() {
        this.queryParamsBuilder.withChildValueObjects(true);
        return this;
    }

    public QueryBuilder limit(int limit) {
        this.queryParamsBuilder.limit(limit);
        return this;
    }

    public QueryBuilder skip(int skip) {
        this.queryParamsBuilder.skip(skip);
        return this;
    }

    public QueryBuilder from(LocalDateTime from) {
        this.queryParamsBuilder.from(from);
        return this;
    }

    public QueryBuilder from(LocalDate fromDate) {
        return this.from(fromDate.atTime(LocalTime.MIDNIGHT));
    }

    public QueryBuilder to(LocalDateTime to) {
        this.queryParamsBuilder.to(to);
        return this;
    }

    public QueryBuilder to(LocalDate toDate) {
        return this.to(toDate.atTime(LocalTime.MIDNIGHT));
    }

    public QueryBuilder withCommitId(CommitId commitId) {
        Validate.argumentIsNotNull(commitId);
        this.queryParamsBuilder.commitId(commitId);
        return this;
    }

    public QueryBuilder withCommitId(BigDecimal commitId) {
        Validate.argumentIsNotNull(commitId);
        this.queryParamsBuilder.commitId(CommitId.valueOf(commitId));
        return this;
    }

    public QueryBuilder withCommitIds(Collection<BigDecimal> commitIds) {
        Validate.argumentIsNotNull(commitIds);
        this.queryParamsBuilder.commitIds(commitIds.stream().map(CommitId::valueOf).collect(Collectors.toSet()));
        return this;
    }

    public QueryBuilder withCommitProperty(String name, String value) {
        Validate.argumentsAreNotNull(name, value);
        this.queryParamsBuilder.commitProperty(name, value);
        return this;
    }

    public QueryBuilder withVersion(long version) {
        Validate.argumentCheck(version > 0L, "Version is not a positive number.");
        this.queryParamsBuilder.version(version);
        return this;
    }

    public QueryBuilder withShadowScope(ShadowScope shadowScope) {
        Validate.argumentIsNotNull((Object)shadowScope);
        this.shadowScope = shadowScope;
        return this;
    }

    public QueryBuilder withShadowScopeDeep() {
        return this.withShadowScope(ShadowScope.COMMIT_DEPTH);
    }

    public QueryBuilder byAuthor(String author) {
        Validate.argumentIsNotNull(author);
        this.queryParamsBuilder.author(author);
        return this;
    }

    public JqlQuery build() {
        return new JqlQuery(this.filter, this.queryParamsBuilder.build(), this.shadowScope);
    }
}

