/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.jql;

import java.util.Optional;
import java.util.Set;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.GlobalIdFactory;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.TypeMapper;
import org.javers.repository.api.QueryParams;
import org.javers.repository.jql.AnyDomainObjectFilter;
import org.javers.repository.jql.ClassFilter;
import org.javers.repository.jql.Filter;
import org.javers.repository.jql.FilterDefinition;
import org.javers.repository.jql.IdFilter;
import org.javers.repository.jql.ShadowScope;
import org.javers.repository.jql.VoOwnerFilter;

public class JqlQuery {
    private final QueryParams queryParams;
    private final FilterDefinition filterDefinition;
    private Filter filter;
    private final ShadowScope shadowScope;

    JqlQuery(FilterDefinition filter, QueryParams queryParams, ShadowScope shadowScope) {
        Validate.argumentsAreNotNull(filter);
        this.queryParams = queryParams;
        this.filterDefinition = filter;
        this.shadowScope = shadowScope;
    }

    private void validate() {
        if (this.queryParams.isAggregate() && !this.isClassQuery() && !this.isInstanceIdQuery()) {
            throw new JaversException(JaversExceptionCode.MALFORMED_JQL, "aggregate filter can be enabled only for byClass and byInstanceId queries");
        }
    }

    public String toString() {
        return "JqlQuery{queryParams=" + this.queryParams + ", filter=" + this.filter + '}';
    }

    QueryParams getQueryParams() {
        return this.queryParams;
    }

    boolean hasFilter(Class<? extends Filter> ofType) {
        return this.getFilter(ofType).isPresent();
    }

    Set<ManagedType> getClassFilter() {
        return this.getFilter(ClassFilter.class).get().getManagedTypes();
    }

    GlobalId getIdFilter() {
        return this.getFilter(IdFilter.class).get().getGlobalId();
    }

    ShadowScope getShadowScope() {
        return this.shadowScope;
    }

    String getChangedProperty() {
        return this.queryParams.changedProperty().get();
    }

    VoOwnerFilter getVoOwnerFilter() {
        return this.getFilter(VoOwnerFilter.class).get();
    }

    <T extends Filter> Optional<T> getFilter(Class<T> ofType) {
        Validate.conditionFulfilled(this.filter != null, "jqlQuery is not compiled");
        if (this.filter.getClass().equals(ofType)) {
            return Optional.of(this.filter);
        }
        return Optional.empty();
    }

    void compile(GlobalIdFactory globalIdFactory, TypeMapper typeMapper) {
        this.filter = this.filterDefinition.compile(globalIdFactory, typeMapper);
        this.validate();
    }

    boolean matches(GlobalId globalId) {
        return this.filter.matches(globalId);
    }

    boolean isNewObjectChanges() {
        return this.queryParams.newObjectChanges();
    }

    boolean isAnyDomainObjectQuery() {
        return this.hasFilter(AnyDomainObjectFilter.class);
    }

    boolean isIdQuery() {
        return this.hasFilter(IdFilter.class);
    }

    boolean hasChangedPropertyFilter() {
        return this.queryParams.changedProperty().isPresent();
    }

    boolean isClassQuery() {
        return this.hasFilter(ClassFilter.class);
    }

    boolean isInstanceIdQuery() {
        Optional<IdFilter> idFilter = this.getFilter(IdFilter.class);
        return idFilter.isPresent() && idFilter.get().isInstanceIdFilter();
    }

    boolean isVoOwnerQuery() {
        return this.hasFilter(VoOwnerFilter.class);
    }
}

