/*
 * Decompiled with CFR 0.152.
 */
package org.javers.guava;

import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.util.ArrayList;
import java.util.List;
import org.javers.core.diff.NodePair;
import org.javers.core.diff.appenders.CorePropertyChangeAppender;
import org.javers.core.diff.changetype.container.ContainerElementChange;
import org.javers.core.diff.changetype.container.SetChange;
import org.javers.core.diff.changetype.container.ValueAdded;
import org.javers.core.diff.changetype.container.ValueRemoved;
import org.javers.core.metamodel.object.DehydrateContainerFunction;
import org.javers.core.metamodel.object.GlobalIdFactory;
import org.javers.core.metamodel.object.OwnerContext;
import org.javers.core.metamodel.object.PropertyOwnerContext;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.TypeMapper;
import org.javers.guava.MultisetType;

class MultisetChangeAppender
extends CorePropertyChangeAppender<SetChange> {
    private final TypeMapper typeMapper;
    private final GlobalIdFactory globalIdFactory;

    MultisetChangeAppender(TypeMapper typeMapper, GlobalIdFactory globalIdFactory) {
        this.typeMapper = typeMapper;
        this.globalIdFactory = globalIdFactory;
    }

    @Override
    public boolean supports(JaversType propertyType) {
        return propertyType instanceof MultisetType;
    }

    @Override
    public SetChange calculateChanges(NodePair pair, Property property) {
        PropertyOwnerContext owner;
        Multiset left = (Multiset)pair.getLeftPropertyValue(property);
        Multiset right = (Multiset)pair.getRightPropertyValue(property);
        MultisetType multisetType = (MultisetType)this.typeMapper.getPropertyType(property);
        List<ContainerElementChange> entryChanges = this.calculateEntryChanges(multisetType, left, right, owner = new PropertyOwnerContext(pair.getGlobalId(), property.getName()));
        if (!entryChanges.isEmpty()) {
            this.renderNotParametrizedWarningIfNeeded(multisetType.getItemType(), "item", "Multiset", property);
            return new SetChange(pair.getGlobalId(), property.getName(), entryChanges);
        }
        return null;
    }

    private List<ContainerElementChange> calculateEntryChanges(MultisetType multisetType, Multiset left, Multiset right, OwnerContext owner) {
        JaversType itemType = this.typeMapper.getJaversType(multisetType.getItemType());
        DehydrateContainerFunction dehydrateFunction = new DehydrateContainerFunction(itemType, this.globalIdFactory);
        Multiset leftMultiset = (Multiset)multisetType.map(left, dehydrateFunction, owner);
        Multiset rightMultiset = (Multiset)multisetType.map(right, dehydrateFunction, owner);
        ArrayList<ContainerElementChange> changes = new ArrayList<ContainerElementChange>();
        for (Object globalCdoId : Multisets.difference((Multiset)leftMultiset, (Multiset)rightMultiset)) {
            changes.add(new ValueRemoved(globalCdoId));
        }
        Multiset difference = Multisets.difference((Multiset)rightMultiset, (Multiset)leftMultiset);
        for (Object globalCdoId : difference) {
            changes.add(new ValueAdded(globalCdoId));
        }
        return changes;
    }
}

