/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.property;

import java.lang.reflect.Type;
import java.util.Optional;
import org.javers.common.collections.Sets;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.reflection.JaversMember;
import org.javers.common.validation.Validate;

public class Property {
    public static final String ID_ANN = "Id";
    public static final String EMBEDDED_ID_ANN = "EmbeddedId";
    private final transient JaversMember member;
    private final transient boolean hasTransientAnn;
    private final transient boolean hasShallowReferenceAnn;
    private String name;

    public Property(JaversMember member, boolean hasTransientAnn, boolean hasShallowReferenceAnn, Optional<String> name) {
        Validate.argumentIsNotNull(member);
        this.member = member;
        this.hasTransientAnn = hasTransientAnn;
        this.hasShallowReferenceAnn = hasShallowReferenceAnn;
        this.name = name.orElse(member.propertyName());
    }

    public Property(JaversMember member, boolean hasTransientAnn) {
        this(member, hasTransientAnn, false, Optional.empty());
    }

    public Type getGenericType() {
        return this.member.getGenericResolvedType();
    }

    public Class<?> getRawType() {
        return this.member.getRawType();
    }

    public boolean looksLikeId() {
        return this.member.hasAnnotation(Sets.asSet(ID_ANN, EMBEDDED_ID_ANN));
    }

    public Object get(Object target) {
        try {
            return this.member.invokeEvenIfPrivate(target);
        }
        catch (JaversException e) {
            if (e.getCode() == JaversExceptionCode.MISSING_PROPERTY) {
                return null;
            }
            throw e;
        }
    }

    public boolean isNull(Object target) {
        return this.get(target) == null;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasTransientAnn() {
        return this.hasTransientAnn;
    }

    public boolean hasShallowReferenceAnn() {
        return this.hasShallowReferenceAnn;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Property that = (Property)o;
        return this.member.equals(that.member);
    }

    public int hashCode() {
        return this.member.hashCode();
    }

    public String toString() {
        return this.member.toString();
    }

    public JaversMember getMember() {
        return this.member;
    }
}

