/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.scanner;

import java.lang.annotation.Annotation;
import java.util.Optional;
import org.javers.common.reflection.ReflectionUtil;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.scanner.AnnotationNamesProvider;
import org.javers.core.metamodel.scanner.ClassAnnotationsScan;

class ClassAnnotationsScanner {
    private final AnnotationNamesProvider annotationNamesProvider;

    ClassAnnotationsScanner(AnnotationNamesProvider annotationNamesProvider) {
        this.annotationNamesProvider = annotationNamesProvider;
    }

    public ClassAnnotationsScan scan(Class javaClass) {
        Validate.argumentIsNotNull(javaClass);
        Optional<String> typeName = ReflectionUtil.findFirst(javaClass, this.annotationNamesProvider.getTypeNameAliases()).map(a -> (String)ReflectionUtil.getAnnotationValue(a, "value"));
        boolean hasValue = false;
        boolean hasIgnored = false;
        boolean hasValueObject = false;
        boolean hasEntity = false;
        boolean hasShallowReference = false;
        boolean hasIgnoreDeclaredProperties = false;
        for (Annotation ann : javaClass.getAnnotations()) {
            if (this.annotationNamesProvider.isEntityAlias(ann)) {
                hasEntity = true;
            }
            if (this.annotationNamesProvider.isValueAlias(ann)) {
                hasValue = true;
            }
            if (this.annotationNamesProvider.isShallowReferenceAlias(ann)) {
                hasShallowReference = true;
            }
            if (this.annotationNamesProvider.isIgnoredTypeAlias(ann)) {
                hasIgnored = true;
            }
            if (this.annotationNamesProvider.isValueObjectAlias(ann)) {
                hasValueObject = true;
            }
            if (!this.annotationNamesProvider.isIgnoreDeclaredPropertiesAlias(ann)) continue;
            hasIgnoreDeclaredProperties = true;
        }
        return new ClassAnnotationsScan(hasValue, hasValueObject, hasEntity, hasShallowReference, hasIgnored, hasIgnoreDeclaredProperties, typeName);
    }
}

