/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.inmemory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.javers.common.collections.Lists;
import org.javers.common.validation.Validate;
import org.javers.core.commit.Commit;
import org.javers.core.commit.CommitId;
import org.javers.core.json.JsonConverter;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.InstanceId;
import org.javers.core.metamodel.object.ValueObjectId;
import org.javers.core.metamodel.type.EntityType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.repository.api.JaversRepository;
import org.javers.repository.api.QueryParams;
import org.javers.repository.api.QueryParamsBuilder;
import org.javers.repository.api.SnapshotIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryRepository
implements JaversRepository {
    private static final Logger logger = LoggerFactory.getLogger(InMemoryRepository.class);
    private Map<GlobalId, LinkedList<CdoSnapshot>> snapshots = new ConcurrentHashMap<GlobalId, LinkedList<CdoSnapshot>>();
    private CommitId head;

    @Override
    public List<CdoSnapshot> getValueObjectStateHistory(EntityType ownerEntity, String path, QueryParams queryParams) {
        Validate.argumentsAreNotNull(ownerEntity, path, queryParams);
        List<CdoSnapshot> result = Lists.positiveFilter(this.getAll(), input -> {
            if (!(input.getGlobalId() instanceof ValueObjectId)) {
                return false;
            }
            ValueObjectId id = (ValueObjectId)input.getGlobalId();
            return id.hasOwnerOfType(ownerEntity) && id.getFragment().equals(path);
        });
        return this.applyQueryParams(result, queryParams);
    }

    @Override
    public List<CdoSnapshot> getStateHistory(GlobalId globalId, QueryParams queryParams) {
        Validate.argumentsAreNotNull(globalId, queryParams);
        ArrayList<CdoSnapshot> filtered = new ArrayList<CdoSnapshot>();
        for (CdoSnapshot snapshot : this.getAll()) {
            if (snapshot.getGlobalId().equals(globalId)) {
                filtered.add(snapshot);
            }
            if (!queryParams.isAggregate() || !this.isParent(globalId, snapshot.getGlobalId())) continue;
            filtered.add(snapshot);
        }
        return this.applyQueryParams(filtered, queryParams);
    }

    private boolean isParent(GlobalId parentCandidate, GlobalId childCandidate) {
        if (!(parentCandidate instanceof InstanceId) || !(childCandidate instanceof ValueObjectId)) {
            return false;
        }
        InstanceId parent = (InstanceId)parentCandidate;
        ValueObjectId child = (ValueObjectId)childCandidate;
        return child.getOwnerId().equals(parent);
    }

    @Override
    public List<CdoSnapshot> getStateHistory(Set<ManagedType> givenClasses, QueryParams queryParams) {
        Validate.argumentsAreNotNull(givenClasses, queryParams);
        ArrayList<CdoSnapshot> filtered = new ArrayList<CdoSnapshot>();
        for (CdoSnapshot snapshot : this.getAll()) {
            for (ManagedType givenClass : givenClasses) {
                if (snapshot.getGlobalId().isTypeOf(givenClass)) {
                    filtered.add(snapshot);
                }
                if (!queryParams.isAggregate() || !this.isParent(givenClass, snapshot.getGlobalId())) continue;
                filtered.add(snapshot);
            }
        }
        return this.applyQueryParams(filtered, queryParams);
    }

    private boolean isParent(ManagedType parentCandidate, GlobalId childCandidate) {
        if (!(parentCandidate instanceof EntityType) || !(childCandidate instanceof ValueObjectId)) {
            return false;
        }
        EntityType parent = (EntityType)parentCandidate;
        ValueObjectId child = (ValueObjectId)childCandidate;
        return child.getOwnerId().getTypeName().equals(parent.getName());
    }

    private QueryParams getQueryParamsWithIncreasedLimit(QueryParams queryParams) {
        return QueryParamsBuilder.initializeWith(queryParams).limit(queryParams.limit() * 10).build();
    }

    private List<CdoSnapshot> applyQueryParams(List<CdoSnapshot> snapshots, QueryParams queryParams) {
        if (queryParams.commitId().isPresent()) {
            snapshots = this.filterSnapshotsByCommitId(snapshots, queryParams.commitId().get());
        }
        if (queryParams.version().isPresent()) {
            snapshots = this.filterSnapshotsByVersion(snapshots, queryParams.version().get());
        }
        if (queryParams.author().isPresent()) {
            snapshots = this.filterSnapshotsByAuthor(snapshots, queryParams.author().get());
        }
        if (queryParams.hasDates()) {
            snapshots = this.filterSnapshotsByCommitDate(snapshots, queryParams);
        }
        if (queryParams.changedProperty().isPresent()) {
            snapshots = this.filterByPropertyName(snapshots, queryParams.changedProperty().get());
        }
        snapshots = this.filterSnapshotsByCommitProperties(snapshots, queryParams.commitProperties());
        return this.trimResultsToRequestedSlice(snapshots, queryParams.skip(), queryParams.limit());
    }

    private List<CdoSnapshot> filterSnapshotsByCommitId(List<CdoSnapshot> snapshots, CommitId commitId) {
        return Lists.positiveFilter(snapshots, snapshot -> commitId.equals(snapshot.getCommitId()));
    }

    private List<CdoSnapshot> filterSnapshotsByVersion(List<CdoSnapshot> snapshots, Long version) {
        return Lists.positiveFilter(snapshots, snapshot -> version.longValue() == snapshot.getVersion());
    }

    private List<CdoSnapshot> filterSnapshotsByAuthor(List<CdoSnapshot> snapshots, String author) {
        return Lists.positiveFilter(snapshots, snapshot -> author.equals(snapshot.getCommitMetadata().getAuthor()));
    }

    private List<CdoSnapshot> filterSnapshotsByCommitDate(List<CdoSnapshot> snapshots, QueryParams queryParams) {
        return Lists.positiveFilter(snapshots, snapshot -> queryParams.isDateInRange(snapshot.getCommitMetadata().getCommitDate()));
    }

    private List<CdoSnapshot> filterSnapshotsByCommitProperties(List<CdoSnapshot> snapshots, Map<String, String> commitProperties) {
        return Lists.positiveFilter(snapshots, snapshot -> commitProperties.entrySet().stream().allMatch(commitProperty -> {
            Map<String, String> actualCommitProperties = snapshot.getCommitMetadata().getProperties();
            return actualCommitProperties.containsKey(commitProperty.getKey()) && actualCommitProperties.get(commitProperty.getKey()).equals(commitProperty.getValue());
        }));
    }

    private List<CdoSnapshot> trimResultsToRequestedSlice(List<CdoSnapshot> snapshots, int from, int size) {
        int fromIndex = Math.min(from, snapshots.size());
        int toIndex = Math.min(from + size, snapshots.size());
        return snapshots.subList(fromIndex, toIndex);
    }

    @Override
    public Optional<CdoSnapshot> getLatest(GlobalId globalId) {
        Validate.argumentsAreNotNull(globalId);
        if (this.snapshots.containsKey(globalId)) {
            LinkedList<CdoSnapshot> states = this.snapshots.get(globalId);
            return Optional.of(states.peek());
        }
        return Optional.empty();
    }

    @Override
    public List<CdoSnapshot> getSnapshots(QueryParams queryParams) {
        Validate.argumentIsNotNull(queryParams);
        return Collections.unmodifiableList(this.applyQueryParams(this.getAll(), queryParams));
    }

    @Override
    public List<CdoSnapshot> getSnapshots(Collection<SnapshotIdentifier> snapshotIdentifiers) {
        return Lists.transform(this.getPersistedIdentifiers(snapshotIdentifiers), snapshotIdentifier -> {
            List objectSnapshots = this.snapshots.get(snapshotIdentifier.getGlobalId());
            return (CdoSnapshot)objectSnapshots.get(objectSnapshots.size() - (int)snapshotIdentifier.getVersion());
        });
    }

    private List<SnapshotIdentifier> getPersistedIdentifiers(Collection<SnapshotIdentifier> snapshotIdentifiers) {
        return Lists.positiveFilter(new ArrayList<SnapshotIdentifier>(snapshotIdentifiers), snapshotIdentifier -> this.snapshots.containsKey(snapshotIdentifier.getGlobalId()) && snapshotIdentifier.getVersion() <= (long)this.snapshots.get(snapshotIdentifier.getGlobalId()).size());
    }

    @Override
    public void persist(Commit commit) {
        Validate.argumentsAreNotNull(commit);
        List<CdoSnapshot> snapshots = commit.getSnapshots();
        for (CdoSnapshot s : snapshots) {
            this.persist(s);
        }
        logger.debug("{} snapshot(s) persisted", (Object)snapshots.size());
        this.head = commit.getId();
    }

    @Override
    public CommitId getHeadId() {
        return this.head;
    }

    @Override
    public void setJsonConverter(JsonConverter jsonConverter) {
    }

    private List<CdoSnapshot> filterByPropertyName(List<CdoSnapshot> snapshots, String propertyName) {
        return Lists.positiveFilter(snapshots, input -> input.hasChangeAt(propertyName));
    }

    private List<CdoSnapshot> getAll() {
        ArrayList<CdoSnapshot> all = new ArrayList<CdoSnapshot>();
        for (LinkedList<CdoSnapshot> snapshotsList : this.snapshots.values()) {
            all.addAll(snapshotsList);
        }
        Collections.sort(all, new Comparator<CdoSnapshot>(){

            @Override
            public int compare(CdoSnapshot o1, CdoSnapshot o2) {
                return o2.getCommitId().compareTo(o1.getCommitId());
            }
        });
        return all;
    }

    private synchronized void persist(CdoSnapshot snapshot) {
        LinkedList<CdoSnapshot> states = this.snapshots.get(snapshot.getGlobalId());
        if (states == null) {
            states = new LinkedList();
            this.snapshots.put(snapshot.getGlobalId(), states);
        }
        states.push(snapshot);
    }

    @Override
    public void ensureSchema() {
    }
}

