/*
 * Decompiled with CFR 0.152.
 */
package org.javers.common.collections;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.javers.common.collections.Arrays;
import org.javers.common.collections.Function;
import org.javers.common.collections.Lists;
import org.javers.common.collections.Predicate;
import org.javers.common.collections.Sets;
import org.javers.common.validation.Validate;

public class Collections {
    public static <F, T> Collection<T> transform(Collection<F> input, Function<F, T> transformation) {
        Validate.argumentsAreNotNull(input, transformation);
        if (input instanceof Set) {
            return Sets.transform((Set)input, transformation);
        }
        if (input instanceof List) {
            return Lists.transform((List)input, transformation);
        }
        throw new IllegalArgumentException("At this moment Javers don't support " + input.getClass().getSimpleName());
    }

    public static <E> Collection<E> difference(Collection<E> first, Collection<E> second) {
        if (first instanceof List) {
            return Lists.difference((List)first, (List)second);
        }
        if (first instanceof Set) {
            return Sets.difference((Set)first, (Set)second);
        }
        throw new IllegalArgumentException("At this moment Javers don't support " + first.getClass().getSimpleName());
    }

    public static Collection<Object> asCollection(Object arrayOrCollection) {
        Validate.argumentIsNotNull(arrayOrCollection);
        if (arrayOrCollection.getClass().isArray()) {
            return Arrays.asList(arrayOrCollection);
        }
        if (arrayOrCollection instanceof Collection) {
            return (Collection)arrayOrCollection;
        }
        throw new IllegalArgumentException("expected Array or Collection, got " + arrayOrCollection.getClass());
    }

    public static <E> boolean allMatch(Collection<E> collection, Predicate<E> predicate) {
        Validate.argumentsAreNotNull(collection, predicate);
        for (E element : collection) {
            if (predicate.apply(element)) continue;
            return false;
        }
        return true;
    }
}

