/*
 * Decompiled with CFR 0.152.
 */
package org.javers.common.reflection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.reflection.JaversMember;
import org.javers.common.string.ToStringBuilder;

public class JaversMethod
extends JaversMember<Method> {
    private static final Object[] EMPTY_ARRAY = new Object[0];

    public JaversMethod(Method rawMethod, Type resolvedReturnType) {
        super(rawMethod, resolvedReturnType);
    }

    @Override
    protected Type getRawGenericType() {
        return ((Method)this.getRawMember()).getGenericReturnType();
    }

    @Override
    public Class<?> getRawType() {
        return ((Method)this.getRawMember()).getReturnType();
    }

    @Override
    public Object invokeEvenIfPrivate(Object onObject) {
        this.setAccessibleIfNecessary();
        try {
            return ((Method)this.getRawMember()).invoke(onObject, EMPTY_ARRAY);
        }
        catch (IllegalArgumentException ie) {
            throw new JaversException(JaversExceptionCode.MISSING_PROPERTY, this, ie.getClass().getName());
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new JaversException(JaversExceptionCode.PROPERTY_ACCESS_ERROR, this, onObject.getClass().getSimpleName(), e.getClass().getName() + ": " + e.getMessage());
        }
    }

    @Override
    public String propertyName() {
        return this.getterToField(this.name());
    }

    public String toString() {
        return "Method " + ToStringBuilder.typeName(this.getGenericResolvedType()) + " " + this.name() + "; //declared in: " + this.getDeclaringClass().getSimpleName();
    }

    private String getterToField(String getterName) {
        if (getterName.substring(0, 3).equals("get")) {
            return getterName.substring(3, 4).toLowerCase() + getterName.substring(4);
        }
        if (getterName.substring(0, 2).equals("is")) {
            return getterName.substring(2, 3).toLowerCase() + getterName.substring(3);
        }
        throw new IllegalArgumentException("Name {" + getterName + "} is not a getter name");
    }
}

