/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.jql;

import java.util.List;
import org.javers.common.collections.Optional;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.validation.Validate;
import org.javers.core.diff.Change;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.GlobalIdFactory;
import org.javers.core.metamodel.type.EntityType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.TypeMapper;
import org.javers.repository.api.JaversExtendedRepository;
import org.javers.repository.jql.GlobalIdDTO;
import org.javers.repository.jql.JqlQuery;
import org.javers.repository.jql.VoOwnerFilter;

public class QueryRunner {
    private final JaversExtendedRepository repository;
    private final GlobalIdFactory globalIdFactory;
    private final TypeMapper typeMapper;

    public QueryRunner(JaversExtendedRepository repository, GlobalIdFactory globalIdFactory, TypeMapper typeMapper) {
        this.repository = repository;
        this.globalIdFactory = globalIdFactory;
        this.typeMapper = typeMapper;
    }

    public Optional<CdoSnapshot> runQueryForLatestSnapshot(GlobalIdDTO globalId) {
        Validate.argumentIsNotNull(globalId);
        return this.repository.getLatest(this.fromDto(globalId));
    }

    public List<CdoSnapshot> queryForSnapshots(JqlQuery query) {
        Validate.argumentIsNotNull(query);
        if (query.isAnyDomainObjectQuery()) {
            return this.repository.getSnapshots(query.getQueryParams());
        }
        if (query.isIdQuery()) {
            return this.repository.getStateHistory(this.fromDto(query.getIdFilter()), query.getQueryParams());
        }
        if (query.isClassQuery()) {
            ManagedType mType = this.typeMapper.getJaversManagedType(query.getClassFilter());
            return this.repository.getStateHistory(mType, query.getQueryParams());
        }
        if (query.isVoOwnerQuery()) {
            VoOwnerFilter filter = query.getVoOwnerFilter();
            EntityType ownerEntity = this.getOwnerEntity(filter);
            this.globalIdFactory.touchValueObjectFromPath(ownerEntity, filter.getPath());
            return this.repository.getValueObjectStateHistory(ownerEntity, filter.getPath(), query.getQueryParams());
        }
        throw new JaversException(JaversExceptionCode.MALFORMED_JQL, "queryForSnapshots: " + query + " is not supported");
    }

    public List<Change> queryForChanges(JqlQuery query) {
        Validate.argumentIsNotNull(query);
        if (query.isAnyDomainObjectQuery()) {
            return this.repository.getChanges(query.isNewObjectChanges(), query.getQueryParams());
        }
        if (query.isIdQuery()) {
            return this.repository.getChangeHistory(this.fromDto(query.getIdFilter()), query.getQueryParams());
        }
        if (query.isClassQuery()) {
            ManagedType mType = this.typeMapper.getJaversManagedType(query.getClassFilter());
            return this.repository.getChangeHistory(mType, query.getQueryParams());
        }
        if (query.isVoOwnerQuery()) {
            VoOwnerFilter filter = query.getVoOwnerFilter();
            EntityType ownerEntity = this.getOwnerEntity(filter);
            this.globalIdFactory.touchValueObjectFromPath(ownerEntity, filter.getPath());
            return this.repository.getValueObjectChangeHistory(ownerEntity, filter.getPath(), query.getQueryParams());
        }
        throw new JaversException(JaversExceptionCode.MALFORMED_JQL, "queryForChanges: " + query + " is not supported");
    }

    private GlobalId fromDto(GlobalIdDTO globalIdDTO) {
        return this.globalIdFactory.createFromDto(globalIdDTO);
    }

    private EntityType getOwnerEntity(VoOwnerFilter filter) {
        ManagedType mType = this.typeMapper.getJaversManagedType(filter.getOwnerEntityClass());
        if (!(mType instanceof EntityType)) {
            throw new JaversException(JaversExceptionCode.MALFORMED_JQL, "queryForChanges: ownerEntityClass {'" + filter.getOwnerEntityClass().getName() + "'} should be an Entity");
        }
        return (EntityType)mType;
    }
}

