/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.json.typeadapter.change;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.core.diff.changetype.container.ContainerChange;
import org.javers.core.diff.changetype.container.ContainerElementChange;
import org.javers.core.diff.changetype.container.ElementValueChange;
import org.javers.core.diff.changetype.container.ValueAddOrRemove;
import org.javers.core.diff.changetype.container.ValueAdded;
import org.javers.core.diff.changetype.container.ValueRemoved;
import org.javers.core.json.typeadapter.change.ChangeTypeAdapter;
import org.javers.core.metamodel.type.ContainerType;
import org.javers.core.metamodel.type.TypeMapper;

abstract class ContainerChangeTypeAdapter<T extends ContainerChange>
extends ChangeTypeAdapter<T> {
    private static final String CHANGES_FIELD = "elementChanges";
    private static final String ELEMENT_CHANGE_TYPE_FIELD = "elementChangeType";
    private static final String INDEX_FIELD = "index";
    private static final String VALUE_FIELD = "value";
    private static final String LEFT_VALUE_FIELD = "leftValue";
    private static final String RIGHT_VALUE_FIELD = "rightValue";

    public ContainerChangeTypeAdapter(TypeMapper typeMapper) {
        super(typeMapper);
    }

    @Override
    public T fromJson(JsonElement json, JsonDeserializationContext context) {
        JsonObject jsonObject = (JsonObject)json;
        ChangeTypeAdapter.PropertyChangeStub stub = this.deserializeStub(jsonObject, context);
        ContainerType containerType = (ContainerType)this.typeMapper.getPropertyType(stub.property);
        List<ContainerElementChange> changes = this.parseChanges(jsonObject, context, containerType);
        return (T)this.appendCommitMetadata(jsonObject, context, this.newInstance(stub, changes));
    }

    protected abstract ContainerChange newInstance(ChangeTypeAdapter.PropertyChangeStub var1, List<ContainerElementChange> var2);

    private List<ContainerElementChange> parseChanges(JsonObject jsonObject, JsonDeserializationContext context, ContainerType containerType) {
        ArrayList<ContainerElementChange> result = new ArrayList<ContainerElementChange>();
        JsonArray array = jsonObject.getAsJsonArray(CHANGES_FIELD);
        for (JsonElement e : array) {
            JsonObject elementChange = (JsonObject)e;
            String elementChangeType = elementChange.get(ELEMENT_CHANGE_TYPE_FIELD).getAsString();
            if (ValueAdded.class.getSimpleName().equals(elementChangeType)) {
                result.add(this.parseValueAdded(elementChange, context, containerType));
                continue;
            }
            if (ValueRemoved.class.getSimpleName().equals(elementChangeType)) {
                result.add(this.parseValueRemoved(elementChange, context, containerType));
                continue;
            }
            if (ElementValueChange.class.getSimpleName().equals(elementChangeType)) {
                result.add(this.parseElementValueChange(elementChange, context, containerType));
                continue;
            }
            throw new JaversException(JaversExceptionCode.MALFORMED_ENTRY_CHANGE_TYPE_FIELD, containerType);
        }
        return result;
    }

    private ElementValueChange parseElementValueChange(JsonObject elementChange, JsonDeserializationContext context, ContainerType containerType) {
        Object lValue = this.decodeValue(elementChange, context, LEFT_VALUE_FIELD, containerType.getItemType());
        Object rValue = this.decodeValue(elementChange, context, RIGHT_VALUE_FIELD, containerType.getItemType());
        return new ElementValueChange(this.parseIndex(elementChange), lValue, rValue);
    }

    private ValueAdded parseValueAdded(JsonObject elementChange, JsonDeserializationContext context, ContainerType containerType) {
        Object value = this.decodeValue(elementChange, context, VALUE_FIELD, containerType.getItemClass());
        Integer idx = this.parseIndex(elementChange);
        if (idx != null) {
            return new ValueAdded((int)idx, value);
        }
        return new ValueAdded(value);
    }

    private ValueRemoved parseValueRemoved(JsonObject elementChange, JsonDeserializationContext context, ContainerType containerType) {
        Object value = this.decodeValue(elementChange, context, VALUE_FIELD, containerType.getItemClass());
        Integer idx = this.parseIndex(elementChange);
        if (idx != null) {
            return new ValueRemoved((int)idx, value);
        }
        return new ValueRemoved(value);
    }

    private Integer parseIndex(JsonObject elementChange) {
        if (!elementChange.has(INDEX_FIELD) || elementChange.get(INDEX_FIELD).isJsonNull()) {
            return null;
        }
        return elementChange.get(INDEX_FIELD).getAsInt();
    }

    private Object decodeValue(JsonObject elementChange, JsonDeserializationContext context, String fieldName, Type expectedType) {
        return context.deserialize(elementChange.get(fieldName), this.typeMapper.getDehydratedType(expectedType));
    }

    @Override
    public JsonElement toJson(T change, JsonSerializationContext context) {
        JsonObject jsonObject = this.createJsonObject(change, context);
        this.appendBody((ContainerChange)change, jsonObject, context);
        return jsonObject;
    }

    private void appendBody(ContainerChange change, JsonObject toJson, JsonSerializationContext context) {
        JsonArray jsonArray = new JsonArray();
        for (ContainerElementChange elementChange : change.getChanges()) {
            JsonObject jsonElement = new JsonObject();
            jsonElement.addProperty(ELEMENT_CHANGE_TYPE_FIELD, elementChange.getClass().getSimpleName());
            jsonElement.addProperty(INDEX_FIELD, (Number)elementChange.getIndex());
            if (elementChange instanceof ValueAddOrRemove) {
                ValueAddOrRemove valueAddOrRemove = (ValueAddOrRemove)elementChange;
                jsonElement.add(VALUE_FIELD, context.serialize(valueAddOrRemove.getValue()));
            }
            if (elementChange instanceof ElementValueChange) {
                ElementValueChange elementValueChange = (ElementValueChange)elementChange;
                jsonElement.add(LEFT_VALUE_FIELD, context.serialize(elementValueChange.getLeftValue()));
                jsonElement.add(RIGHT_VALUE_FIELD, context.serialize(elementValueChange.getRightValue()));
            }
            jsonArray.add((JsonElement)jsonElement);
        }
        toJson.add(CHANGES_FIELD, (JsonElement)jsonArray);
    }
}

