/*
 * Decompiled with CFR 0.152.
 */
package org.javers.common.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.javers.common.reflection.JaversField;
import org.javers.common.reflection.TypeResolvingContext;

class JaversFieldFactory {
    private final Class methodSource;

    public JaversFieldFactory(Class methodSource) {
        this.methodSource = methodSource;
    }

    public List<JaversField> getAllFields() {
        ArrayList<JaversField> fields = new ArrayList<JaversField>();
        TypeResolvingContext context = new TypeResolvingContext();
        for (Class clazz = this.methodSource; clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
            context.addTypeSubstitutions(clazz);
            for (Field f : clazz.getDeclaredFields()) {
                fields.add(this.createJField(f, context));
            }
        }
        return fields;
    }

    private JaversField createJField(Field rawField, TypeResolvingContext context) {
        Type actualType = context.getSubstitution(rawField.getGenericType());
        return new JaversField(rawField, actualType);
    }
}

