/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.javers.common.collections.Primitives;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.reflection.ReflectionUtil;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.clazz.ClientsClassDefinition;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.scanner.ClassScanner;
import org.javers.core.metamodel.type.ArrayType;
import org.javers.core.metamodel.type.CollectionType;
import org.javers.core.metamodel.type.ContainerType;
import org.javers.core.metamodel.type.CustomType;
import org.javers.core.metamodel.type.DehydratedTypeFactory;
import org.javers.core.metamodel.type.DuckType;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.ListType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.MapContentType;
import org.javers.core.metamodel.type.MapType;
import org.javers.core.metamodel.type.OptionalType;
import org.javers.core.metamodel.type.PrimitiveType;
import org.javers.core.metamodel.type.SetType;
import org.javers.core.metamodel.type.TypeFactory;
import org.javers.core.metamodel.type.TypeMapperState;
import org.javers.core.metamodel.type.ValueObjectType;
import org.javers.core.metamodel.type.ValueType;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public class TypeMapper {
    private final TypeMapperState state;
    private final DehydratedTypeFactory dehydratedTypeFactory = new DehydratedTypeFactory(this);

    public TypeMapper(ClassScanner classScanner) {
        TypeFactory typeFactory = new TypeFactory(classScanner, this);
        this.state = new TypeMapperState(typeFactory);
        this.registerCoreTypes();
    }

    protected TypeMapper(TypeFactory typeFactory) {
        this.state = new TypeMapperState(typeFactory);
        this.registerCoreTypes();
    }

    private void registerCoreTypes() {
        for (Class<?> primitiveOrBox : Primitives.getPrimitiveAndBoxTypes()) {
            this.registerPrimitiveType(primitiveOrBox);
        }
        this.registerPrimitiveType(String.class);
        this.registerPrimitiveType(CharSequence.class);
        this.registerPrimitiveType(Enum.class);
        this.addType(new ArrayType((Type)((Object)Object[].class)));
        this.registerValueType(LocalDateTime.class);
        this.registerValueType(LocalDate.class);
        this.registerValueType(BigDecimal.class);
        this.registerValueType(Date.class);
        this.registerValueType(ThreadLocal.class);
        this.addType(new CollectionType((Type)((Object)Collection.class)));
        this.addType(new SetType((Type)((Object)Set.class)));
        this.addType(new ListType((Type)((Object)List.class)));
        this.addType(new MapType((Type)((Object)Map.class)));
        if (ReflectionUtil.isJava8runtime()) {
            this.addType(new OptionalType());
        }
    }

    public MapContentType getMapContentType(MapType mapType) {
        JaversType keyType = this.getJaversType(mapType.getKeyType());
        JaversType valueType = this.getJaversType(mapType.getValueType());
        return new MapContentType(keyType, valueType);
    }

    public MapContentType getMapContentType(ContainerType containerType) {
        JaversType keyType = this.getJaversType((Type)((Object)Integer.class));
        JaversType valueType = this.getJaversType(containerType.getItemType());
        return new MapContentType(keyType, valueType);
    }

    public JaversType getJaversType(Type javaType) {
        Validate.argumentIsNotNull(javaType);
        return this.state.getJaversType(javaType);
    }

    public ManagedType getJaversManagedType(String typeName) {
        return this.getJaversManagedType(this.state.getClassByTypeName(typeName), ManagedType.class);
    }

    public ManagedType getJaversManagedType(GlobalId globalId) {
        return this.getJaversManagedType(this.state.getClassByTypeName(globalId.getTypeName()), ManagedType.class);
    }

    public <T extends ManagedType> T getJaversManagedType(String typeName, Class<T> expectedType) {
        return this.getJaversManagedType(this.state.getClassByTypeName(typeName), expectedType);
    }

    public <T extends ManagedType> T getJaversManagedType(DuckType duckType, Class<T> expectedType) {
        return this.getJaversManagedType(this.state.getClassByDuckType(duckType), expectedType);
    }

    public ManagedType getJaversManagedType(Class javaType) {
        return this.getJaversManagedType(javaType, ManagedType.class);
    }

    public <T extends ManagedType> T getJaversManagedType(Class javaClass, Class<T> expectedType) {
        JaversType mType = this.getJaversType(javaClass);
        if (expectedType.isAssignableFrom(mType.getClass())) {
            return (T)((ManagedType)mType);
        }
        throw new JaversException(JaversExceptionCode.MANAGED_CLASS_MAPPING_ERROR, javaClass, mType.getClass().getSimpleName(), expectedType.getSimpleName());
    }

    public <T extends JaversType> T getPropertyType(Property property) {
        Validate.argumentIsNotNull(property);
        return (T)this.getJaversType(property.getGenericType());
    }

    private void registerPrimitiveType(Class<?> primitiveClass) {
        this.addType(new PrimitiveType(primitiveClass));
    }

    public void registerClientsClass(ClientsClassDefinition def) {
        this.state.computeIfAbsent(def);
    }

    public void registerValueType(Class<?> valueCLass) {
        this.addType(new ValueType(valueCLass));
    }

    public void registerCustomType(Class<?> customCLass) {
        this.addType(new CustomType(customCLass));
    }

    public boolean isValueObject(Type type) {
        JaversType jType = this.getJaversType(type);
        return jType instanceof ValueObjectType;
    }

    public Type getDehydratedType(Type type) {
        return this.dehydratedTypeFactory.build(type);
    }

    private void addType(JaversType jType) {
        this.state.putIfAbsent(jType.getBaseJavaType(), jType);
    }

    boolean contains(Type javaType) {
        return this.state.contains(javaType);
    }
}

