/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.javers.common.collections.EnumerableFunction;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.object.OwnerContext;
import org.javers.core.metamodel.type.EnumerableType;
import org.javers.core.metamodel.type.MapEnumerationOwnerContext;

public class MapType
extends EnumerableType {
    public MapType(Type baseJavaType) {
        super(baseJavaType, 2);
    }

    @Override
    public Map map(Object sourceMap_, EnumerableFunction mapFunction, OwnerContext owner) {
        return MapType.mapStatic(sourceMap_, mapFunction, owner);
    }

    public static Map mapStatic(Object sourceMap_, EnumerableFunction mapFunction, OwnerContext owner) {
        Validate.argumentIsNotNull(mapFunction);
        if (sourceMap_ == null) {
            return Collections.EMPTY_MAP;
        }
        Map sourceMap = (Map)sourceMap_;
        HashMap targetMap = new HashMap(sourceMap.size());
        MapEnumerationOwnerContext mapEnumerationContext = new MapEnumerationOwnerContext(owner);
        for (Map.Entry entry : sourceMap.entrySet()) {
            mapEnumerationContext.switchToKey();
            Object mappedKey = mapFunction.apply(entry.getKey(), mapEnumerationContext);
            mapEnumerationContext.switchToValue(mappedKey);
            Object mappedValue = mapFunction.apply(entry.getValue(), mapEnumerationContext);
            targetMap.put(mappedKey, mappedValue);
        }
        return Collections.unmodifiableMap(targetMap);
    }

    @Override
    public boolean isEmpty(Object map) {
        return map == null || ((Map)map).isEmpty();
    }

    public Type getKeyType() {
        return this.getConcreteClassTypeArguments().get(0);
    }

    public Type getValueType() {
        return this.getConcreteClassTypeArguments().get(1);
    }
}

